/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.PcreqMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcreqMessageBuilder {
    private List<Requests> _requests;
    private List<Svec> _svec;
    private ProtocolVersion _version;
    private static List<Range<BigInteger>> _version_range;
    Map<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>> augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>();

    public PcreqMessageBuilder() {
    }

    public PcreqMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcreqMessageBuilder(PcreqMessage base) {
        this._requests = base.getRequests();
        this._svec = base.getSvec();
        this._version = base.getVersion();
        if (base instanceof PcreqMessageImpl) {
            PcreqMessageImpl _impl = (PcreqMessageImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader] \nbut was: " + arg);
        }
    }

    public List<Requests> getRequests() {
        return this._requests;
    }

    public List<Svec> getSvec() {
        return this._svec;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<PcreqMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PcreqMessageBuilder setRequests(List<Requests> value) {
        this._requests = value;
        return this;
    }

    public PcreqMessageBuilder setSvec(List<Svec> value) {
        this._svec = value;
        return this;
    }

    public PcreqMessageBuilder setVersion(ProtocolVersion value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue().shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcreqMessageBuilder._version_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _version_range));
            }
        }
        this._version = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _version_range() {
        if (_version_range != null) return _version_range;
        Class<PcreqMessageBuilder> clazz = PcreqMessageBuilder.class;
        synchronized (PcreqMessageBuilder.class) {
            if (_version_range != null) return _version_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
            _version_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _version_range;
        }
    }

    public PcreqMessageBuilder addAugmentation(Class<? extends Augmentation<PcreqMessage>> augmentationType, Augmentation<PcreqMessage> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PcreqMessage build() {
        return new PcreqMessageImpl(this);
    }

    private static final class PcreqMessageImpl
    implements PcreqMessage {
        private final List<Requests> _requests;
        private final List<Svec> _svec;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>> augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>();

        public Class<PcreqMessage> getImplementedInterface() {
            return PcreqMessage.class;
        }

        private PcreqMessageImpl(PcreqMessageBuilder base) {
            this._requests = base.getRequests();
            this._svec = base.getSvec();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Requests> getRequests() {
            return this._requests;
        }

        @Override
        public List<Svec> getSvec() {
            return this._svec;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public <E extends Augmentation<PcreqMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._requests == null ? 0 : this._requests.hashCode());
            result = 31 * result + (this._svec == null ? 0 : this._svec.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcreqMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcreqMessage other = (PcreqMessage)obj;
            if (this._requests == null ? other.getRequests() != null : !this._requests.equals(other.getRequests())) {
                return false;
            }
            if (this._svec == null ? other.getSvec() != null : !this._svec.equals(other.getSvec())) {
                return false;
            }
            if (this._version == null ? other.getVersion() != null : !this._version.equals(other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcreqMessageImpl otherImpl = (PcreqMessageImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PcreqMessage [");
            boolean first = true;
            if (this._requests != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_requests=");
                builder.append(this._requests);
            }
            if (this._svec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_svec=");
                builder.append(this._svec);
            }
            if (this._version != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_version=");
                builder.append(this._version);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

