/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RpBuilder {
    private Short _priority;
    private static List<Range<BigInteger>> _priority_range;
    private RequestId _requestId;
    private static List<Range<BigInteger>> _requestId_range;
    private Tlvs _tlvs;
    private Boolean _biDirectional;
    private Boolean _eroCompression;
    private Boolean _fragmentation;
    private Boolean _ignore;
    private Boolean _loose;
    private Boolean _makeBeforeBreak;
    private Boolean _order;
    private Boolean _p2mp;
    private Boolean _pathKey;
    private Boolean _processingRule;
    private Boolean _reoptimization;
    private Boolean _supplyOf;
    Map<Class<? extends Augmentation<Rp>>, Augmentation<Rp>> augmentation = new HashMap<Class<? extends Augmentation<Rp>>, Augmentation<Rp>>();

    public RpBuilder() {
    }

    public RpBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public RpBuilder(Rp base) {
        this._priority = base.getPriority();
        this._requestId = base.getRequestId();
        this._tlvs = base.getTlvs();
        this._biDirectional = base.isBiDirectional();
        this._eroCompression = base.isEroCompression();
        this._fragmentation = base.isFragmentation();
        this._ignore = base.isIgnore();
        this._loose = base.isLoose();
        this._makeBeforeBreak = base.isMakeBeforeBreak();
        this._order = base.isOrder();
        this._p2mp = base.isP2mp();
        this._pathKey = base.isPathKey();
        this._processingRule = base.isProcessingRule();
        this._reoptimization = base.isReoptimization();
        this._supplyOf = base.isSupplyOf();
        if (base instanceof RpImpl) {
            RpImpl _impl = (RpImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Rp>>, Augmentation<Rp>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Short getPriority() {
        return this._priority;
    }

    public RequestId getRequestId() {
        return this._requestId;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isBiDirectional() {
        return this._biDirectional;
    }

    public Boolean isEroCompression() {
        return this._eroCompression;
    }

    public Boolean isFragmentation() {
        return this._fragmentation;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isLoose() {
        return this._loose;
    }

    public Boolean isMakeBeforeBreak() {
        return this._makeBeforeBreak;
    }

    public Boolean isOrder() {
        return this._order;
    }

    public Boolean isP2mp() {
        return this._p2mp;
    }

    public Boolean isPathKey() {
        return this._pathKey;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public Boolean isReoptimization() {
        return this._reoptimization;
    }

    public Boolean isSupplyOf() {
        return this._supplyOf;
    }

    public <E extends Augmentation<Rp>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RpBuilder setPriority(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : RpBuilder._priority_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _priority_range));
            }
        }
        this._priority = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _priority_range() {
        if (_priority_range != null) return _priority_range;
        Class<RpBuilder> clazz = RpBuilder.class;
        synchronized (RpBuilder.class) {
            if (_priority_range != null) return _priority_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
            _priority_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _priority_range;
        }
    }

    public RpBuilder setRequestId(RequestId value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : RpBuilder._requestId_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _requestId_range));
            }
        }
        this._requestId = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _requestId_range() {
        if (_requestId_range != null) return _requestId_range;
        Class<RpBuilder> clazz = RpBuilder.class;
        synchronized (RpBuilder.class) {
            if (_requestId_range != null) return _requestId_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _requestId_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _requestId_range;
        }
    }

    public RpBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public RpBuilder setBiDirectional(Boolean value) {
        this._biDirectional = value;
        return this;
    }

    public RpBuilder setEroCompression(Boolean value) {
        this._eroCompression = value;
        return this;
    }

    public RpBuilder setFragmentation(Boolean value) {
        this._fragmentation = value;
        return this;
    }

    public RpBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public RpBuilder setLoose(Boolean value) {
        this._loose = value;
        return this;
    }

    public RpBuilder setMakeBeforeBreak(Boolean value) {
        this._makeBeforeBreak = value;
        return this;
    }

    public RpBuilder setOrder(Boolean value) {
        this._order = value;
        return this;
    }

    public RpBuilder setP2mp(Boolean value) {
        this._p2mp = value;
        return this;
    }

    public RpBuilder setPathKey(Boolean value) {
        this._pathKey = value;
        return this;
    }

    public RpBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public RpBuilder setReoptimization(Boolean value) {
        this._reoptimization = value;
        return this;
    }

    public RpBuilder setSupplyOf(Boolean value) {
        this._supplyOf = value;
        return this;
    }

    public RpBuilder addAugmentation(Class<? extends Augmentation<Rp>> augmentationType, Augmentation<Rp> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Rp build() {
        return new RpImpl(this);
    }

    private static final class RpImpl
    implements Rp {
        private final Short _priority;
        private final RequestId _requestId;
        private final Tlvs _tlvs;
        private final Boolean _biDirectional;
        private final Boolean _eroCompression;
        private final Boolean _fragmentation;
        private final Boolean _ignore;
        private final Boolean _loose;
        private final Boolean _makeBeforeBreak;
        private final Boolean _order;
        private final Boolean _p2mp;
        private final Boolean _pathKey;
        private final Boolean _processingRule;
        private final Boolean _reoptimization;
        private final Boolean _supplyOf;
        private Map<Class<? extends Augmentation<Rp>>, Augmentation<Rp>> augmentation = new HashMap<Class<? extends Augmentation<Rp>>, Augmentation<Rp>>();

        public Class<Rp> getImplementedInterface() {
            return Rp.class;
        }

        private RpImpl(RpBuilder base) {
            this._priority = base.getPriority();
            this._requestId = base.getRequestId();
            this._tlvs = base.getTlvs();
            this._biDirectional = base.isBiDirectional();
            this._eroCompression = base.isEroCompression();
            this._fragmentation = base.isFragmentation();
            this._ignore = base.isIgnore();
            this._loose = base.isLoose();
            this._makeBeforeBreak = base.isMakeBeforeBreak();
            this._order = base.isOrder();
            this._p2mp = base.isP2mp();
            this._pathKey = base.isPathKey();
            this._processingRule = base.isProcessingRule();
            this._reoptimization = base.isReoptimization();
            this._supplyOf = base.isSupplyOf();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Rp>>, Augmentation<Rp>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Rp>>, Augmentation<Rp>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getPriority() {
            return this._priority;
        }

        @Override
        public RequestId getRequestId() {
            return this._requestId;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isBiDirectional() {
            return this._biDirectional;
        }

        @Override
        public Boolean isEroCompression() {
            return this._eroCompression;
        }

        @Override
        public Boolean isFragmentation() {
            return this._fragmentation;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isLoose() {
            return this._loose;
        }

        @Override
        public Boolean isMakeBeforeBreak() {
            return this._makeBeforeBreak;
        }

        @Override
        public Boolean isOrder() {
            return this._order;
        }

        @Override
        public Boolean isP2mp() {
            return this._p2mp;
        }

        @Override
        public Boolean isPathKey() {
            return this._pathKey;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean isReoptimization() {
            return this._reoptimization;
        }

        @Override
        public Boolean isSupplyOf() {
            return this._supplyOf;
        }

        public <E extends Augmentation<Rp>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._priority == null ? 0 : this._priority.hashCode());
            result = 31 * result + (this._requestId == null ? 0 : this._requestId.hashCode());
            result = 31 * result + (this._tlvs == null ? 0 : this._tlvs.hashCode());
            result = 31 * result + (this._biDirectional == null ? 0 : this._biDirectional.hashCode());
            result = 31 * result + (this._eroCompression == null ? 0 : this._eroCompression.hashCode());
            result = 31 * result + (this._fragmentation == null ? 0 : this._fragmentation.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._loose == null ? 0 : this._loose.hashCode());
            result = 31 * result + (this._makeBeforeBreak == null ? 0 : this._makeBeforeBreak.hashCode());
            result = 31 * result + (this._order == null ? 0 : this._order.hashCode());
            result = 31 * result + (this._p2mp == null ? 0 : this._p2mp.hashCode());
            result = 31 * result + (this._pathKey == null ? 0 : this._pathKey.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this._reoptimization == null ? 0 : this._reoptimization.hashCode());
            result = 31 * result + (this._supplyOf == null ? 0 : this._supplyOf.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Rp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Rp other = (Rp)obj;
            if (this._priority == null ? other.getPriority() != null : !this._priority.equals(other.getPriority())) {
                return false;
            }
            if (this._requestId == null ? other.getRequestId() != null : !this._requestId.equals(other.getRequestId())) {
                return false;
            }
            if (this._tlvs == null ? other.getTlvs() != null : !this._tlvs.equals(other.getTlvs())) {
                return false;
            }
            if (this._biDirectional == null ? other.isBiDirectional() != null : !this._biDirectional.equals(other.isBiDirectional())) {
                return false;
            }
            if (this._eroCompression == null ? other.isEroCompression() != null : !this._eroCompression.equals(other.isEroCompression())) {
                return false;
            }
            if (this._fragmentation == null ? other.isFragmentation() != null : !this._fragmentation.equals(other.isFragmentation())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._loose == null ? other.isLoose() != null : !this._loose.equals(other.isLoose())) {
                return false;
            }
            if (this._makeBeforeBreak == null ? other.isMakeBeforeBreak() != null : !this._makeBeforeBreak.equals(other.isMakeBeforeBreak())) {
                return false;
            }
            if (this._order == null ? other.isOrder() != null : !this._order.equals(other.isOrder())) {
                return false;
            }
            if (this._p2mp == null ? other.isP2mp() != null : !this._p2mp.equals(other.isP2mp())) {
                return false;
            }
            if (this._pathKey == null ? other.isPathKey() != null : !this._pathKey.equals(other.isPathKey())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this._reoptimization == null ? other.isReoptimization() != null : !this._reoptimization.equals(other.isReoptimization())) {
                return false;
            }
            if (this._supplyOf == null ? other.isSupplyOf() != null : !this._supplyOf.equals(other.isSupplyOf())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RpImpl otherImpl = (RpImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Rp>>, Augmentation<Rp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Rp [");
            boolean first = true;
            if (this._priority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_priority=");
                builder.append(this._priority);
            }
            if (this._requestId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_requestId=");
                builder.append(this._requestId);
            }
            if (this._tlvs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tlvs=");
                builder.append(this._tlvs);
            }
            if (this._biDirectional != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_biDirectional=");
                builder.append(this._biDirectional);
            }
            if (this._eroCompression != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_eroCompression=");
                builder.append(this._eroCompression);
            }
            if (this._fragmentation != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_fragmentation=");
                builder.append(this._fragmentation);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._loose != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_loose=");
                builder.append(this._loose);
            }
            if (this._makeBeforeBreak != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_makeBeforeBreak=");
                builder.append(this._makeBeforeBreak);
            }
            if (this._order != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_order=");
                builder.append(this._order);
            }
            if (this._p2mp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_p2mp=");
                builder.append(this._p2mp);
            }
            if (this._pathKey != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_pathKey=");
                builder.append(this._pathKey);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (this._reoptimization != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_reoptimization=");
                builder.append(this._reoptimization);
            }
            if (this._supplyOf != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_supplyOf=");
                builder.append(this._supplyOf);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

