/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.Svec;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SvecBuilder {
    private List<RequestId> _requestsIds;
    private Boolean _ignore;
    private Boolean _linkDiverse;
    private Boolean _nodeDiverse;
    private Boolean _processingRule;
    private Boolean _srlgDiverse;
    Map<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> augmentation = new HashMap<Class<? extends Augmentation<Svec>>, Augmentation<Svec>>();

    public SvecBuilder() {
    }

    public SvecBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public SvecBuilder(Svec base) {
        this._requestsIds = base.getRequestsIds();
        this._ignore = base.isIgnore();
        this._linkDiverse = base.isLinkDiverse();
        this._nodeDiverse = base.isNodeDiverse();
        this._processingRule = base.isProcessingRule();
        this._srlgDiverse = base.isSrlgDiverse();
        if (base instanceof SvecImpl) {
            SvecImpl _impl = (SvecImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<Svec>>, Augmentation<Svec>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public List<RequestId> getRequestsIds() {
        return this._requestsIds;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isLinkDiverse() {
        return this._linkDiverse;
    }

    public Boolean isNodeDiverse() {
        return this._nodeDiverse;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public Boolean isSrlgDiverse() {
        return this._srlgDiverse;
    }

    public <E extends Augmentation<Svec>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SvecBuilder setRequestsIds(List<RequestId> value) {
        this._requestsIds = value;
        return this;
    }

    public SvecBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public SvecBuilder setLinkDiverse(Boolean value) {
        this._linkDiverse = value;
        return this;
    }

    public SvecBuilder setNodeDiverse(Boolean value) {
        this._nodeDiverse = value;
        return this;
    }

    public SvecBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public SvecBuilder setSrlgDiverse(Boolean value) {
        this._srlgDiverse = value;
        return this;
    }

    public SvecBuilder addAugmentation(Class<? extends Augmentation<Svec>> augmentationType, Augmentation<Svec> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Svec build() {
        return new SvecImpl(this);
    }

    private static final class SvecImpl
    implements Svec {
        private final List<RequestId> _requestsIds;
        private final Boolean _ignore;
        private final Boolean _linkDiverse;
        private final Boolean _nodeDiverse;
        private final Boolean _processingRule;
        private final Boolean _srlgDiverse;
        private Map<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> augmentation = new HashMap<Class<? extends Augmentation<Svec>>, Augmentation<Svec>>();

        public Class<Svec> getImplementedInterface() {
            return Svec.class;
        }

        private SvecImpl(SvecBuilder base) {
            this._requestsIds = base.getRequestsIds();
            this._ignore = base.isIgnore();
            this._linkDiverse = base.isLinkDiverse();
            this._nodeDiverse = base.isNodeDiverse();
            this._processingRule = base.isProcessingRule();
            this._srlgDiverse = base.isSrlgDiverse();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Svec>>, Augmentation<Svec>>(base.augmentation);
                }
            }
        }

        @Override
        public List<RequestId> getRequestsIds() {
            return this._requestsIds;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isLinkDiverse() {
            return this._linkDiverse;
        }

        @Override
        public Boolean isNodeDiverse() {
            return this._nodeDiverse;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean isSrlgDiverse() {
            return this._srlgDiverse;
        }

        public <E extends Augmentation<Svec>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._requestsIds == null ? 0 : this._requestsIds.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._linkDiverse == null ? 0 : this._linkDiverse.hashCode());
            result = 31 * result + (this._nodeDiverse == null ? 0 : this._nodeDiverse.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this._srlgDiverse == null ? 0 : this._srlgDiverse.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Svec.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Svec other = (Svec)obj;
            if (this._requestsIds == null ? other.getRequestsIds() != null : !this._requestsIds.equals(other.getRequestsIds())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._linkDiverse == null ? other.isLinkDiverse() != null : !this._linkDiverse.equals(other.isLinkDiverse())) {
                return false;
            }
            if (this._nodeDiverse == null ? other.isNodeDiverse() != null : !this._nodeDiverse.equals(other.isNodeDiverse())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this._srlgDiverse == null ? other.isSrlgDiverse() != null : !this._srlgDiverse.equals(other.isSrlgDiverse())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SvecImpl otherImpl = (SvecImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Svec [");
            boolean first = true;
            if (this._requestsIds != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_requestsIds=");
                builder.append(this._requestsIds);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._linkDiverse != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_linkDiverse=");
                builder.append(this._linkDiverse);
            }
            if (this._nodeDiverse != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nodeDiverse=");
                builder.append(this._nodeDiverse);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (this._srlgDiverse != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srlgDiverse=");
                builder.append(this._srlgDiverse);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

