/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VendorInformationObjectBuilder {
    private EnterpriseNumber _enterpriseNumber;
    private static List<Range<BigInteger>> _enterpriseNumber_range;
    private EnterpriseSpecificInformation _enterpriseSpecificInformation;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> augmentation = new HashMap<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>>();

    public VendorInformationObjectBuilder() {
    }

    public VendorInformationObjectBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public VendorInformationObjectBuilder(VendorInformation arg) {
        this._enterpriseNumber = arg.getEnterpriseNumber();
        this._enterpriseSpecificInformation = arg.getEnterpriseSpecificInformation();
    }

    public VendorInformationObjectBuilder(VendorInformationObject base) {
        this._enterpriseNumber = base.getEnterpriseNumber();
        this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof VendorInformationObjectImpl) {
            VendorInformationObjectImpl _impl = (VendorInformationObjectImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof VendorInformation) {
            this._enterpriseNumber = ((VendorInformation)arg).getEnterpriseNumber();
            this._enterpriseSpecificInformation = ((VendorInformation)arg).getEnterpriseSpecificInformation();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformation] \nbut was: " + arg);
        }
    }

    public EnterpriseNumber getEnterpriseNumber() {
        return this._enterpriseNumber;
    }

    public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
        return this._enterpriseSpecificInformation;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<VendorInformationObject>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VendorInformationObjectBuilder setEnterpriseNumber(EnterpriseNumber value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : VendorInformationObjectBuilder._enterpriseNumber_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _enterpriseNumber_range));
            }
        }
        this._enterpriseNumber = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _enterpriseNumber_range() {
        if (_enterpriseNumber_range != null) return _enterpriseNumber_range;
        Class<VendorInformationObjectBuilder> clazz = VendorInformationObjectBuilder.class;
        synchronized (VendorInformationObjectBuilder.class) {
            if (_enterpriseNumber_range != null) return _enterpriseNumber_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _enterpriseNumber_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _enterpriseNumber_range;
        }
    }

    public VendorInformationObjectBuilder setEnterpriseSpecificInformation(EnterpriseSpecificInformation value) {
        this._enterpriseSpecificInformation = value;
        return this;
    }

    public VendorInformationObjectBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public VendorInformationObjectBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public VendorInformationObjectBuilder addAugmentation(Class<? extends Augmentation<VendorInformationObject>> augmentationType, Augmentation<VendorInformationObject> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VendorInformationObject build() {
        return new VendorInformationObjectImpl(this);
    }

    private static final class VendorInformationObjectImpl
    implements VendorInformationObject {
        private final EnterpriseNumber _enterpriseNumber;
        private final EnterpriseSpecificInformation _enterpriseSpecificInformation;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> augmentation = new HashMap<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>>();

        public Class<VendorInformationObject> getImplementedInterface() {
            return VendorInformationObject.class;
        }

        private VendorInformationObjectImpl(VendorInformationObjectBuilder base) {
            this._enterpriseNumber = base.getEnterpriseNumber();
            this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>>(base.augmentation);
                }
            }
        }

        @Override
        public EnterpriseNumber getEnterpriseNumber() {
            return this._enterpriseNumber;
        }

        @Override
        public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
            return this._enterpriseSpecificInformation;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<VendorInformationObject>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._enterpriseNumber == null ? 0 : this._enterpriseNumber.hashCode());
            result = 31 * result + (this._enterpriseSpecificInformation == null ? 0 : this._enterpriseSpecificInformation.hashCode());
            result = 31 * result + (this._ignore == null ? 0 : this._ignore.hashCode());
            result = 31 * result + (this._processingRule == null ? 0 : this._processingRule.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VendorInformationObject.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VendorInformationObject other = (VendorInformationObject)obj;
            if (this._enterpriseNumber == null ? other.getEnterpriseNumber() != null : !this._enterpriseNumber.equals((Object)other.getEnterpriseNumber())) {
                return false;
            }
            if (this._enterpriseSpecificInformation == null ? other.getEnterpriseSpecificInformation() != null : !this._enterpriseSpecificInformation.equals(other.getEnterpriseSpecificInformation())) {
                return false;
            }
            if (this._ignore == null ? other.isIgnore() != null : !this._ignore.equals(other.isIgnore())) {
                return false;
            }
            if (this._processingRule == null ? other.isProcessingRule() != null : !this._processingRule.equals(other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VendorInformationObjectImpl otherImpl = (VendorInformationObjectImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("VendorInformationObject [");
            boolean first = true;
            if (this._enterpriseNumber != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_enterpriseNumber=");
                builder.append(this._enterpriseNumber);
            }
            if (this._enterpriseSpecificInformation != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_enterpriseSpecificInformation=");
                builder.append(this._enterpriseSpecificInformation);
            }
            if (this._ignore != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ignore=");
                builder.append(this._ignore);
            }
            if (this._processingRule != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

