/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VendorInformationTlvBuilder {
    private EnterpriseNumber _enterpriseNumber;
    private static List<Range<BigInteger>> _enterpriseNumber_range;
    private EnterpriseSpecificInformation _enterpriseSpecificInformation;
    Map<Class<? extends Augmentation<VendorInformationTlv>>, Augmentation<VendorInformationTlv>> augmentation = new HashMap<Class<? extends Augmentation<VendorInformationTlv>>, Augmentation<VendorInformationTlv>>();

    public VendorInformationTlvBuilder() {
    }

    public VendorInformationTlvBuilder(VendorInformation arg) {
        this._enterpriseNumber = arg.getEnterpriseNumber();
        this._enterpriseSpecificInformation = arg.getEnterpriseSpecificInformation();
    }

    public VendorInformationTlvBuilder(VendorInformationTlv base) {
        this._enterpriseNumber = base.getEnterpriseNumber();
        this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
        if (base instanceof VendorInformationTlvImpl) {
            VendorInformationTlvImpl _impl = (VendorInformationTlvImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<VendorInformationTlv>>, Augmentation<VendorInformationTlv>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VendorInformation) {
            this._enterpriseNumber = ((VendorInformation)arg).getEnterpriseNumber();
            this._enterpriseSpecificInformation = ((VendorInformation)arg).getEnterpriseSpecificInformation();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformation] \nbut was: " + arg);
        }
    }

    public EnterpriseNumber getEnterpriseNumber() {
        return this._enterpriseNumber;
    }

    public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
        return this._enterpriseSpecificInformation;
    }

    public <E extends Augmentation<VendorInformationTlv>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VendorInformationTlvBuilder setEnterpriseNumber(EnterpriseNumber value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : VendorInformationTlvBuilder._enterpriseNumber_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _enterpriseNumber_range));
            }
        }
        this._enterpriseNumber = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _enterpriseNumber_range() {
        if (_enterpriseNumber_range != null) return _enterpriseNumber_range;
        Class<VendorInformationTlvBuilder> clazz = VendorInformationTlvBuilder.class;
        synchronized (VendorInformationTlvBuilder.class) {
            if (_enterpriseNumber_range != null) return _enterpriseNumber_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _enterpriseNumber_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _enterpriseNumber_range;
        }
    }

    public VendorInformationTlvBuilder setEnterpriseSpecificInformation(EnterpriseSpecificInformation value) {
        this._enterpriseSpecificInformation = value;
        return this;
    }

    public VendorInformationTlvBuilder addAugmentation(Class<? extends Augmentation<VendorInformationTlv>> augmentationType, Augmentation<VendorInformationTlv> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VendorInformationTlv build() {
        return new VendorInformationTlvImpl(this);
    }

    private static final class VendorInformationTlvImpl
    implements VendorInformationTlv {
        private final EnterpriseNumber _enterpriseNumber;
        private final EnterpriseSpecificInformation _enterpriseSpecificInformation;
        private Map<Class<? extends Augmentation<VendorInformationTlv>>, Augmentation<VendorInformationTlv>> augmentation = new HashMap<Class<? extends Augmentation<VendorInformationTlv>>, Augmentation<VendorInformationTlv>>();

        public Class<VendorInformationTlv> getImplementedInterface() {
            return VendorInformationTlv.class;
        }

        private VendorInformationTlvImpl(VendorInformationTlvBuilder base) {
            this._enterpriseNumber = base.getEnterpriseNumber();
            this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VendorInformationTlv>>, Augmentation<VendorInformationTlv>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VendorInformationTlv>>, Augmentation<VendorInformationTlv>>(base.augmentation);
                }
            }
        }

        @Override
        public EnterpriseNumber getEnterpriseNumber() {
            return this._enterpriseNumber;
        }

        @Override
        public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
            return this._enterpriseSpecificInformation;
        }

        public <E extends Augmentation<VendorInformationTlv>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._enterpriseNumber == null ? 0 : this._enterpriseNumber.hashCode());
            result = 31 * result + (this._enterpriseSpecificInformation == null ? 0 : this._enterpriseSpecificInformation.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VendorInformationTlv.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VendorInformationTlv other = (VendorInformationTlv)obj;
            if (this._enterpriseNumber == null ? other.getEnterpriseNumber() != null : !this._enterpriseNumber.equals((Object)other.getEnterpriseNumber())) {
                return false;
            }
            if (this._enterpriseSpecificInformation == null ? other.getEnterpriseSpecificInformation() != null : !this._enterpriseSpecificInformation.equals(other.getEnterpriseSpecificInformation())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VendorInformationTlvImpl otherImpl = (VendorInformationTlvImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VendorInformationTlv>>, Augmentation<VendorInformationTlv>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("VendorInformationTlv [");
            boolean first = true;
            if (this._enterpriseNumber != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_enterpriseNumber=");
                builder.append(this._enterpriseNumber);
            }
            if (this._enterpriseSpecificInformation != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_enterpriseSpecificInformation=");
                builder.append(this._enterpriseSpecificInformation);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

