/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vs.tlv;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vs.tlv.VsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vs.tlv.vs.tlv.VendorPayload;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VsTlvBuilder {
    private EnterpriseNumber _enterpriseNumber;
    private static List<Range<BigInteger>> _enterpriseNumber_range;
    private VendorPayload _vendorPayload;
    Map<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>> augmentation = new HashMap<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>>();

    public VsTlvBuilder() {
    }

    public VsTlvBuilder(VsTlv base) {
        this._enterpriseNumber = base.getEnterpriseNumber();
        this._vendorPayload = base.getVendorPayload();
        if (base instanceof VsTlvImpl) {
            VsTlvImpl _impl = (VsTlvImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>>(_impl.augmentation);
        }
    }

    public EnterpriseNumber getEnterpriseNumber() {
        return this._enterpriseNumber;
    }

    public VendorPayload getVendorPayload() {
        return this._vendorPayload;
    }

    public <E extends Augmentation<VsTlv>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VsTlvBuilder setEnterpriseNumber(EnterpriseNumber value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : VsTlvBuilder._enterpriseNumber_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _enterpriseNumber_range));
            }
        }
        this._enterpriseNumber = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _enterpriseNumber_range() {
        if (_enterpriseNumber_range != null) return _enterpriseNumber_range;
        Class<VsTlvBuilder> clazz = VsTlvBuilder.class;
        synchronized (VsTlvBuilder.class) {
            if (_enterpriseNumber_range != null) return _enterpriseNumber_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _enterpriseNumber_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _enterpriseNumber_range;
        }
    }

    public VsTlvBuilder setVendorPayload(VendorPayload value) {
        this._vendorPayload = value;
        return this;
    }

    public VsTlvBuilder addAugmentation(Class<? extends Augmentation<VsTlv>> augmentationType, Augmentation<VsTlv> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public VsTlv build() {
        return new VsTlvImpl(this);
    }

    private static final class VsTlvImpl
    implements VsTlv {
        private final EnterpriseNumber _enterpriseNumber;
        private final VendorPayload _vendorPayload;
        private Map<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>> augmentation = new HashMap<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>>();

        public Class<VsTlv> getImplementedInterface() {
            return VsTlv.class;
        }

        private VsTlvImpl(VsTlvBuilder base) {
            this._enterpriseNumber = base.getEnterpriseNumber();
            this._vendorPayload = base.getVendorPayload();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>>(base.augmentation);
                }
            }
        }

        @Override
        public EnterpriseNumber getEnterpriseNumber() {
            return this._enterpriseNumber;
        }

        @Override
        public VendorPayload getVendorPayload() {
            return this._vendorPayload;
        }

        public <E extends Augmentation<VsTlv>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._enterpriseNumber == null ? 0 : this._enterpriseNumber.hashCode());
            result = 31 * result + (this._vendorPayload == null ? 0 : this._vendorPayload.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VsTlv.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VsTlv other = (VsTlv)obj;
            if (this._enterpriseNumber == null ? other.getEnterpriseNumber() != null : !this._enterpriseNumber.equals((Object)other.getEnterpriseNumber())) {
                return false;
            }
            if (this._vendorPayload == null ? other.getVendorPayload() != null : !this._vendorPayload.equals(other.getVendorPayload())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VsTlvImpl otherImpl = (VsTlvImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("VsTlv [");
            boolean first = true;
            if (this._enterpriseNumber != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_enterpriseNumber=");
                builder.append(this._enterpriseNumber);
            }
            if (this._vendorPayload != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_vendorPayload=");
                builder.append(this._vendorPayload);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

