package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.PcepSessionState;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * The statistics of PCEP received/sent messages from the PCE point of view.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * container messages {
 *     leaf received-msg-count {
 *         type uint32;
 *     }
 *     leaf sent-msg-count {
 *         type uint32;
 *     }
 *     leaf last-sent-msg-timestamp {
 *         type uint32;
 *     }
 *     leaf unknown-msg-received {
 *         type uint16;
 *     }
 *     container error-messages {
 *         leaf received-error-msg-count {
 *             type uint32;
 *         }
 *         leaf sent-error-msg-count {
 *             type uint32;
 *         }
 *         container last-received-error {
 *             leaf error-type {
 *                 type error-type;
 *             }
 *             leaf error-value {
 *                 type error-value;
 *             }
 *             uses error;
 *         }
 *         container last-sent-error {
 *             leaf error-type {
 *                 type error-type;
 *             }
 *             leaf error-value {
 *                 type error-value;
 *             }
 *             uses error;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-session-stats/pcep-session-state/messages</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.MessagesBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.MessagesBuilder
 *
 */
public interface Messages
    extends
    ChildOf<PcepSessionState>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:stats",
        "2014-10-06", "messages").intern();

    /**
     * Total number of received PCEP messages.
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>receivedMsgCount</code>, or <code>null</code> if not present
     */
    java.lang.Long getReceivedMsgCount();
    
    /**
     * Total number of sent PCEP messages.
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>sentMsgCount</code>, or <code>null</code> if not present
     */
    java.lang.Long getSentMsgCount();
    
    /**
     * The timestamp of last sent message.
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>lastSentMsgTimestamp</code>, or <code>null</code> if not present
     */
    java.lang.Long getLastSentMsgTimestamp();
    
    /**
     * The number of received unknown messages.
     *
     *
     *
     * @return <code>java.lang.Integer</code> <code>unknownMsgReceived</code>, or <code>null</code> if not present
     */
    java.lang.Integer getUnknownMsgReceived();
    
    /**
     * The message statistics of received/sent PCErr messages.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages</code> <code>errorMessages</code>, or <code>null</code> if not present
     */
    ErrorMessages getErrorMessages();

}

