package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages
 *
 */
public class MessagesBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages> {

    private ErrorMessages _errorMessages;
    private java.lang.Long _lastSentMsgTimestamp;
    private java.lang.Long _receivedMsgCount;
    private java.lang.Long _sentMsgCount;
    private java.lang.Integer _unknownMsgReceived;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>> augmentation = Collections.emptyMap();

    public MessagesBuilder() {
    }

    public MessagesBuilder(Messages base) {
        this._errorMessages = base.getErrorMessages();
        this._lastSentMsgTimestamp = base.getLastSentMsgTimestamp();
        this._receivedMsgCount = base.getReceivedMsgCount();
        this._sentMsgCount = base.getSentMsgCount();
        this._unknownMsgReceived = base.getUnknownMsgReceived();
        if (base instanceof MessagesImpl) {
            MessagesImpl impl = (MessagesImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public ErrorMessages getErrorMessages() {
        return _errorMessages;
    }
    
    public java.lang.Long getLastSentMsgTimestamp() {
        return _lastSentMsgTimestamp;
    }
    
    public java.lang.Long getReceivedMsgCount() {
        return _receivedMsgCount;
    }
    
    public java.lang.Long getSentMsgCount() {
        return _sentMsgCount;
    }
    
    public java.lang.Integer getUnknownMsgReceived() {
        return _unknownMsgReceived;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public MessagesBuilder setErrorMessages(final ErrorMessages value) {
        this._errorMessages = value;
        return this;
    }
    
     
     private static void checkLastSentMsgTimestampRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public MessagesBuilder setLastSentMsgTimestamp(final java.lang.Long value) {
    if (value != null) {
        checkLastSentMsgTimestampRange(value);
    }
        this._lastSentMsgTimestamp = value;
        return this;
    }
    
     
     private static void checkReceivedMsgCountRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public MessagesBuilder setReceivedMsgCount(final java.lang.Long value) {
    if (value != null) {
        checkReceivedMsgCountRange(value);
    }
        this._receivedMsgCount = value;
        return this;
    }
    
     
     private static void checkSentMsgCountRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public MessagesBuilder setSentMsgCount(final java.lang.Long value) {
    if (value != null) {
        checkSentMsgCountRange(value);
    }
        this._sentMsgCount = value;
        return this;
    }
    
     
     private static void checkUnknownMsgReceivedRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public MessagesBuilder setUnknownMsgReceived(final java.lang.Integer value) {
    if (value != null) {
        checkUnknownMsgReceivedRange(value);
    }
        this._unknownMsgReceived = value;
        return this;
    }
    
    public MessagesBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public MessagesBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Messages build() {
        return new MessagesImpl(this);
    }

    private static final class MessagesImpl implements Messages {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages.class;
        }

        private final ErrorMessages _errorMessages;
        private final java.lang.Long _lastSentMsgTimestamp;
        private final java.lang.Long _receivedMsgCount;
        private final java.lang.Long _sentMsgCount;
        private final java.lang.Integer _unknownMsgReceived;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>> augmentation = Collections.emptyMap();

        private MessagesImpl(MessagesBuilder base) {
            this._errorMessages = base.getErrorMessages();
            this._lastSentMsgTimestamp = base.getLastSentMsgTimestamp();
            this._receivedMsgCount = base.getReceivedMsgCount();
            this._sentMsgCount = base.getSentMsgCount();
            this._unknownMsgReceived = base.getUnknownMsgReceived();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public ErrorMessages getErrorMessages() {
            return _errorMessages;
        }
        
        @Override
        public java.lang.Long getLastSentMsgTimestamp() {
            return _lastSentMsgTimestamp;
        }
        
        @Override
        public java.lang.Long getReceivedMsgCount() {
            return _receivedMsgCount;
        }
        
        @Override
        public java.lang.Long getSentMsgCount() {
            return _sentMsgCount;
        }
        
        @Override
        public java.lang.Integer getUnknownMsgReceived() {
            return _unknownMsgReceived;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_errorMessages);
            result = prime * result + Objects.hashCode(_lastSentMsgTimestamp);
            result = prime * result + Objects.hashCode(_receivedMsgCount);
            result = prime * result + Objects.hashCode(_sentMsgCount);
            result = prime * result + Objects.hashCode(_unknownMsgReceived);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages)obj;
            if (!Objects.equals(_errorMessages, other.getErrorMessages())) {
                return false;
            }
            if (!Objects.equals(_lastSentMsgTimestamp, other.getLastSentMsgTimestamp())) {
                return false;
            }
            if (!Objects.equals(_receivedMsgCount, other.getReceivedMsgCount())) {
                return false;
            }
            if (!Objects.equals(_sentMsgCount, other.getSentMsgCount())) {
                return false;
            }
            if (!Objects.equals(_unknownMsgReceived, other.getUnknownMsgReceived())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                MessagesImpl otherImpl = (MessagesImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "Messages [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_errorMessages != null) {
                builder.append("_errorMessages=");
                builder.append(_errorMessages);
                builder.append(", ");
            }
            if (_lastSentMsgTimestamp != null) {
                builder.append("_lastSentMsgTimestamp=");
                builder.append(_lastSentMsgTimestamp);
                builder.append(", ");
            }
            if (_receivedMsgCount != null) {
                builder.append("_receivedMsgCount=");
                builder.append(_receivedMsgCount);
                builder.append(", ");
            }
            if (_sentMsgCount != null) {
                builder.append("_sentMsgCount=");
                builder.append(_sentMsgCount);
                builder.append(", ");
            }
            if (_unknownMsgReceived != null) {
                builder.append("_unknownMsgReceived=");
                builder.append(_unknownMsgReceived);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
