package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.PcepSessionState;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.Preferences;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * The remote peer (PCC) preferences.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * container peer-pref {
 *     leaf keepalive {
 *         type keepalive;
 *     }
 *     leaf deadtimer {
 *         type deadtimer;
 *     }
 *     leaf ip-address {
 *         type ip-address;
 *     }
 *     leaf session-id {
 *         type session-id;
 *     }
 *     uses preferences;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-session-stats/pcep-session-state/peer-pref</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.PeerPrefBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.PeerPrefBuilder
 *
 */
public interface PeerPref
    extends
    ChildOf<PcepSessionState>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.PeerPref>,
    Preferences
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:stats",
        "2014-10-06", "peer-pref").intern();


}

