package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.error.messages.LastReceivedError;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.error.messages.LastSentError;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages
 *
 */
public class ErrorMessagesBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages> {

    private LastReceivedError _lastReceivedError;
    private LastSentError _lastSentError;
    private java.lang.Long _receivedErrorMsgCount;
    private java.lang.Long _sentErrorMsgCount;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>> augmentation = Collections.emptyMap();

    public ErrorMessagesBuilder() {
    }

    public ErrorMessagesBuilder(ErrorMessages base) {
        this._lastReceivedError = base.getLastReceivedError();
        this._lastSentError = base.getLastSentError();
        this._receivedErrorMsgCount = base.getReceivedErrorMsgCount();
        this._sentErrorMsgCount = base.getSentErrorMsgCount();
        if (base instanceof ErrorMessagesImpl) {
            ErrorMessagesImpl impl = (ErrorMessagesImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public LastReceivedError getLastReceivedError() {
        return _lastReceivedError;
    }
    
    public LastSentError getLastSentError() {
        return _lastSentError;
    }
    
    public java.lang.Long getReceivedErrorMsgCount() {
        return _receivedErrorMsgCount;
    }
    
    public java.lang.Long getSentErrorMsgCount() {
        return _sentErrorMsgCount;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public ErrorMessagesBuilder setLastReceivedError(final LastReceivedError value) {
        this._lastReceivedError = value;
        return this;
    }
    
     
    public ErrorMessagesBuilder setLastSentError(final LastSentError value) {
        this._lastSentError = value;
        return this;
    }
    
     
     private static void checkReceivedErrorMsgCountRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public ErrorMessagesBuilder setReceivedErrorMsgCount(final java.lang.Long value) {
    if (value != null) {
        checkReceivedErrorMsgCountRange(value);
    }
        this._receivedErrorMsgCount = value;
        return this;
    }
    
     
     private static void checkSentErrorMsgCountRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public ErrorMessagesBuilder setSentErrorMsgCount(final java.lang.Long value) {
    if (value != null) {
        checkSentErrorMsgCountRange(value);
    }
        this._sentErrorMsgCount = value;
        return this;
    }
    
    public ErrorMessagesBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ErrorMessagesBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ErrorMessages build() {
        return new ErrorMessagesImpl(this);
    }

    private static final class ErrorMessagesImpl implements ErrorMessages {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages.class;
        }

        private final LastReceivedError _lastReceivedError;
        private final LastSentError _lastSentError;
        private final java.lang.Long _receivedErrorMsgCount;
        private final java.lang.Long _sentErrorMsgCount;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>> augmentation = Collections.emptyMap();

        private ErrorMessagesImpl(ErrorMessagesBuilder base) {
            this._lastReceivedError = base.getLastReceivedError();
            this._lastSentError = base.getLastSentError();
            this._receivedErrorMsgCount = base.getReceivedErrorMsgCount();
            this._sentErrorMsgCount = base.getSentErrorMsgCount();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public LastReceivedError getLastReceivedError() {
            return _lastReceivedError;
        }
        
        @Override
        public LastSentError getLastSentError() {
            return _lastSentError;
        }
        
        @Override
        public java.lang.Long getReceivedErrorMsgCount() {
            return _receivedErrorMsgCount;
        }
        
        @Override
        public java.lang.Long getSentErrorMsgCount() {
            return _sentErrorMsgCount;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_lastReceivedError);
            result = prime * result + Objects.hashCode(_lastSentError);
            result = prime * result + Objects.hashCode(_receivedErrorMsgCount);
            result = prime * result + Objects.hashCode(_sentErrorMsgCount);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages)obj;
            if (!Objects.equals(_lastReceivedError, other.getLastReceivedError())) {
                return false;
            }
            if (!Objects.equals(_lastSentError, other.getLastSentError())) {
                return false;
            }
            if (!Objects.equals(_receivedErrorMsgCount, other.getReceivedErrorMsgCount())) {
                return false;
            }
            if (!Objects.equals(_sentErrorMsgCount, other.getSentErrorMsgCount())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ErrorMessagesImpl otherImpl = (ErrorMessagesImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "ErrorMessages [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_lastReceivedError != null) {
                builder.append("_lastReceivedError=");
                builder.append(_lastReceivedError);
                builder.append(", ");
            }
            if (_lastSentError != null) {
                builder.append("_lastSentError=");
                builder.append(_lastSentError);
                builder.append(", ");
            }
            if (_receivedErrorMsgCount != null) {
                builder.append("_receivedErrorMsgCount=");
                builder.append(_receivedErrorMsgCount);
                builder.append(", ");
            }
            if (_sentErrorMsgCount != null) {
                builder.append("_sentErrorMsgCount=");
                builder.append(_sentErrorMsgCount);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
