package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcerrMessage;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-message</b>
 * <pre>
 * notification pcerr {
 *     container pcerr-message {
 *         list errors {
 *             key     container error-object {
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     container req-missing {
 *                         leaf request-id {
 *                             type request-id;
 *                         }
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                     uses req-missing-tlv;
 *                 }
 *                 leaf type {
 *                     type uint8;
 *                 }
 *                 leaf value {
 *                     type uint8;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses pcep-error-object;
 *         }
 *         choice error-type {
 *             case request-case {
 *                 container request {
 *                     list rps {
 *                         key     container rp {
 *                             container tlvs {
 *                                 list vendor-information-tlv {
 *                                     key     leaf enterprise-number {
 *                                         type enterprise-number;
 *                                     }
 *                                     choice enterprise-specific-information {
 *                                     }
 *                                     uses vendor-information;
 *                                     uses tlv;
 *                                 }
 *                                 container path-setup-type {
 *                                     leaf pst {
 *                                         type pst;
 *                                     }
 *                                     uses tlv;
 *                                 }
 *                                 container order {
 *                                     leaf delete {
 *                                         type uint32;
 *                                     }
 *                                     leaf setup {
 *                                         type uint32;
 *                                     }
 *                                     uses tlv;
 *                                 }
 *                                 uses vendor-information-tlvs;
 *                                 uses order-tlv;
 *                                 uses path-setup-type-tlv;
 *                             }
 *                             leaf priority {
 *                                 type uint8;
 *                             }
 *                             leaf request-id {
 *                                 type request-id;
 *                             }
 *                             leaf reoptimization {
 *                                 type reoptimization;
 *                             }
 *                             leaf bi-directional {
 *                                 type bi-directional;
 *                             }
 *                             leaf loose {
 *                                 type loose;
 *                             }
 *                             leaf path-key {
 *                                 type path-key;
 *                             }
 *                             leaf fragmentation {
 *                                 type fragmentation;
 *                             }
 *                             leaf p2mp {
 *                                 type p2mp;
 *                             }
 *                             leaf ero-compression {
 *                                 type ero-compression;
 *                             }
 *                             leaf supply-of {
 *                                 type supply-of;
 *                             }
 *                             leaf order {
 *                                 type order;
 *                             }
 *                             leaf make-before-break {
 *                                 type make-before-break;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses rp-object;
 *                     }
 *                 }
 *             }
 *             case session-case {
 *                 container session {
 *                     container open {
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 key     leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             container of-list {
 *                                 leaf-list codes {
 *                                     type of-id;
 *                                 }
 *                                 uses tlv;
 *                             }
 *                             uses of-list-tlv;
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf version {
 *                             type version;
 *                         }
 *                         leaf keepalive {
 *                             type uint8;
 *                         }
 *                         leaf dead-timer {
 *                             type uint8;
 *                         }
 *                         leaf session-id {
 *                             type uint8;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     uses open-object;
 *                 }
 *             }
 *         }
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 *     uses pcerr-message;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-message/pcerr</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcerrBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcerrBuilder
 *
 */
public interface Pcerr
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcerr>,
    PcerrMessage,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:message",
        "2013-10-07", "pcerr").intern();


}

