package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcreqMessage;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-message</b>
 * <pre>
 * notification pcmonreq {
 *     container pcreq-message {
 *         list requests {
 *             key     container path-key-expansion {
 *                 container path-key {
 *                     list path-keys {
 *                         key     leaf loose {
 *                             type loose;
 *                         }
 *                         leaf pce-id {
 *                             type pce-id;
 *                         }
 *                         leaf path-key {
 *                             type path-key;
 *                         }
 *                         uses path-key-subobject;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses path-key-object;
 *             }
 *             container segment-computation {
 *                 container p2p {
 *                     container reported-route {
 *                         container reoptimization-bandwidth {
 *                             leaf bandwidth {
 *                                 type bandwidth;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                             uses bandwidth;
 *                         }
 *                         container rro {
 *                             list subobject {
 *                                 key     leaf protection-available {
 *                                     type protection-available;
 *                                 }
 *                                 leaf protection-in-use {
 *                                     type protection-in-use;
 *                                 }
 *                                 choice subobject-type {
 *                                     case ip-prefix-case {
 *                                         container ip-prefix {
 *                                             leaf ip-prefix {
 *                                                 type ip-prefix;
 *                                             }
 *                                             uses ip-prefix-subobject;
 *                                         }
 *                                     }
 *                                     case label-case {
 *                                         container label {
 *                                             leaf global {
 *                                                 type global;
 *                                             }
 *                                             leaf uni-directional {
 *                                                 type boolean;
 *                                             }
 *                                             choice label-type {
 *                                                 case generalized-label-case {
 *                                                     container generalized-label {
 *                                                         leaf generalized-label {
 *                                                             type binary;
 *                                                         }
 *                                                         uses generalized-label;
 *                                                     }
 *                                                 }
 *                                                 case type1-label-case {
 *                                                     container type1-label {
 *                                                         leaf type1-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses type1-label;
 *                                                     }
 *                                                 }
 *                                                 case waveband-switching-label-case {
 *                                                     container waveband-switching-label {
 *                                                         leaf end-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf start-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf waveband-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses waveband-switching-label;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses label-subobject;
 *                                         }
 *                                     }
 *                                     case path-key-case {
 *                                         container path-key {
 *                                             leaf pce-id {
 *                                                 type pce-id;
 *                                             }
 *                                             leaf path-key {
 *                                                 type path-key;
 *                                             }
 *                                             uses path-key-subobject;
 *                                         }
 *                                     }
 *                                     case unnumbered-case {
 *                                         container unnumbered {
 *                                             leaf router-id {
 *                                                 type uint32;
 *                                             }
 *                                             leaf interface-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses unnumbered-subobject;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses record-route-subobjects;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses reoptimization-bandwidth-object;
 *                         uses reported-route-object;
 *                     }
 *                     container load-balancing {
 *                         leaf max-lsp {
 *                             type uint8;
 *                         }
 *                         leaf min-bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     list vendor-information-object {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses vendor-information;
 *                         uses object;
 *                     }
 *                     container endpoints-obj {
 *                         choice address-family {
 *                             case ipv4-case {
 *                                 container ipv4 {
 *                                     leaf source-ipv4-address {
 *                                         type ipv4-address;
 *                                     }
 *                                     leaf destination-ipv4-address {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv6-case {
 *                                 container ipv6 {
 *                                     leaf source-ipv6-address {
 *                                         type ipv6-address;
 *                                     }
 *                                     leaf destination-ipv6-address {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses endpoints;
 *                     }
 *                     list metrics {
 *                         key     container metric {
 *                             leaf metric-type {
 *                                 type uint8;
 *                             }
 *                             leaf bound {
 *                                 type bound;
 *                             }
 *                             leaf computed {
 *                                 type computed;
 *                             }
 *                             leaf value {
 *                                 type float32;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses metric-object;
 *                     }
 *                     container bandwidth {
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses bandwidth;
 *                     }
 *                     container lspa {
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 key     leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         leaf local-protection-desired {
 *                             type local-protection-desired;
 *                         }
 *                         leaf label-recording-desired {
 *                             type label-recording-desired;
 *                         }
 *                         leaf se-style-desired {
 *                             type se-style-desired;
 *                         }
 *                         leaf session-name {
 *                             type string;
 *                         }
 *                         leaf hold-priority {
 *                             type hold-priority;
 *                         }
 *                         leaf setup-priority {
 *                             type setup-priority;
 *                         }
 *                         leaf include-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf exclude-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf include-all {
 *                             type attribute-filter;
 *                         }
 *                         uses tunnel-attributes;
 *                         uses object;
 *                     }
 *                     container reoptimization-bandwidth {
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses bandwidth;
 *                     }
 *                     container of {
 *                         leaf code {
 *                             type of-id;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 key     leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container class-type {
 *                         leaf class-type {
 *                             type class-type;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container rro {
 *                         list subobject {
 *                             key     leaf protection-available {
 *                                 type protection-available;
 *                             }
 *                             leaf protection-in-use {
 *                                 type protection-in-use;
 *                             }
 *                             choice subobject-type {
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf global {
 *                                             type global;
 *                                         }
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses record-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container xro {
 *                         leaf flags {
 *                             type bits;
 *                         }
 *                         list subobject {
 *                             key     leaf mandatory {
 *                                 type mandatory;
 *                             }
 *                             leaf attribute {
 *                                 type enumeration;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses exclude-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container iro {
 *                         list subobject {
 *                             key     leaf loose {
 *                                 type boolean;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case exrs-case {
 *                                     container exrs {
 *                                         list exrs {
 *                                             key     leaf mandatory {
 *                                                 type mandatory;
 *                                             }
 *                                             leaf attribute {
 *                                                 type enumeration;
 *                                             }
 *                                             choice subobject-type {
 *                                                 case as-number-case {
 *                                                     container as-number {
 *                                                         leaf as-number {
 *                                                             type as-number;
 *                                                         }
 *                                                         uses as-number-subobject;
 *                                                     }
 *                                                 }
 *                                                 case ip-prefix-case {
 *                                                     container ip-prefix {
 *                                                         leaf ip-prefix {
 *                                                             type ip-prefix;
 *                                                         }
 *                                                         uses ip-prefix-subobject;
 *                                                     }
 *                                                 }
 *                                                 case label-case {
 *                                                     container label {
 *                                                         leaf uni-directional {
 *                                                             type boolean;
 *                                                         }
 *                                                         choice label-type {
 *                                                             case generalized-label-case {
 *                                                                 container generalized-label {
 *                                                                     leaf generalized-label {
 *                                                                         type binary;
 *                                                                     }
 *                                                                     uses generalized-label;
 *                                                                 }
 *                                                             }
 *                                                             case type1-label-case {
 *                                                                 container type1-label {
 *                                                                     leaf type1-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses type1-label;
 *                                                                 }
 *                                                             }
 *                                                             case waveband-switching-label-case {
 *                                                                 container waveband-switching-label {
 *                                                                     leaf end-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf start-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf waveband-id {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses waveband-switching-label;
 *                                                                 }
 *                                                             }
 *                                                         }
 *                                                         uses label-subobject;
 *                                                     }
 *                                                 }
 *                                                 case srlg-case {
 *                                                     container srlg {
 *                                                         leaf srlg-id {
 *                                                             type srlg-id;
 *                                                         }
 *                                                         uses srlg-subobject;
 *                                                     }
 *                                                 }
 *                                                 case unnumbered-case {
 *                                                     container unnumbered {
 *                                                         leaf router-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf interface-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses unnumbered-subobject;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses exclude-route-subobjects;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses explicit-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     uses endpoints-object;
 *                     uses vendor-information-objects;
 *                     uses load-balancing-object;
 *                     uses lsp-attributes;
 *                 }
 *             }
 *             container rp {
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     container path-setup-type {
 *                         leaf pst {
 *                             type pst;
 *                         }
 *                         uses tlv;
 *                     }
 *                     container order {
 *                         leaf delete {
 *                             type uint32;
 *                         }
 *                         leaf setup {
 *                             type uint32;
 *                         }
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                     uses order-tlv;
 *                     uses path-setup-type-tlv;
 *                 }
 *                 leaf priority {
 *                     type uint8;
 *                 }
 *                 leaf request-id {
 *                     type request-id;
 *                 }
 *                 leaf reoptimization {
 *                     type reoptimization;
 *                 }
 *                 leaf bi-directional {
 *                     type bi-directional;
 *                 }
 *                 leaf loose {
 *                     type loose;
 *                 }
 *                 leaf path-key {
 *                     type path-key;
 *                 }
 *                 leaf fragmentation {
 *                     type fragmentation;
 *                 }
 *                 leaf p2mp {
 *                     type p2mp;
 *                 }
 *                 leaf ero-compression {
 *                     type ero-compression;
 *                 }
 *                 leaf supply-of {
 *                     type supply-of;
 *                 }
 *                 leaf order {
 *                     type order;
 *                 }
 *                 leaf make-before-break {
 *                     type make-before-break;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             list vendor-information-object {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses vendor-information;
 *                 uses object;
 *             }
 *             uses rp-object;
 *             uses vendor-information-objects;
 *         }
 *         list svec {
 *             key     list metric {
 *                 key     container metric {
 *                     leaf metric-type {
 *                         type uint8;
 *                     }
 *                     leaf bound {
 *                         type bound;
 *                     }
 *                     leaf computed {
 *                         type computed;
 *                     }
 *                     leaf value {
 *                         type float32;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses metric-object;
 *             }
 *             container gc {
 *                 leaf max-hop {
 *                     type uint8;
 *                 }
 *                 leaf max-utilization {
 *                     type max-utilization;
 *                 }
 *                 leaf min-utilization {
 *                     type min-utilization;
 *                 }
 *                 leaf over-booking-factor {
 *                     type over-booking-factor;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container of {
 *                 leaf code {
 *                     type of-id;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             list vendor-information-object {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses vendor-information;
 *                 uses object;
 *             }
 *             container svec {
 *                 leaf link-diverse {
 *                     type link-diverse;
 *                 }
 *                 leaf node-diverse {
 *                     type node-diverse;
 *                 }
 *                 leaf srlg-diverse {
 *                     type srlg-diverse;
 *                 }
 *                 leaf-list requests-ids {
 *                     type request-id;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container xro {
 *                 leaf flags {
 *                     type bits;
 *                 }
 *                 list subobject {
 *                     key     leaf mandatory {
 *                         type mandatory;
 *                     }
 *                     leaf attribute {
 *                         type enumeration;
 *                     }
 *                     choice subobject-type {
 *                         case as-number-case {
 *                             container as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                                 uses as-number-subobject;
 *                             }
 *                         }
 *                         case ip-prefix-case {
 *                             container ip-prefix {
 *                                 leaf ip-prefix {
 *                                     type ip-prefix;
 *                                 }
 *                                 uses ip-prefix-subobject;
 *                             }
 *                         }
 *                         case label-case {
 *                             container label {
 *                                 leaf uni-directional {
 *                                     type boolean;
 *                                 }
 *                                 choice label-type {
 *                                     case generalized-label-case {
 *                                         container generalized-label {
 *                                             leaf generalized-label {
 *                                                 type binary;
 *                                             }
 *                                             uses generalized-label;
 *                                         }
 *                                     }
 *                                     case type1-label-case {
 *                                         container type1-label {
 *                                             leaf type1-label {
 *                                                 type uint32;
 *                                             }
 *                                             uses type1-label;
 *                                         }
 *                                     }
 *                                     case waveband-switching-label-case {
 *                                         container waveband-switching-label {
 *                                             leaf end-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf start-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf waveband-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses waveband-switching-label;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses label-subobject;
 *                             }
 *                         }
 *                         case srlg-case {
 *                             container srlg {
 *                                 leaf srlg-id {
 *                                     type srlg-id;
 *                                 }
 *                                 uses srlg-subobject;
 *                             }
 *                         }
 *                         case unnumbered-case {
 *                             container unnumbered {
 *                                 leaf router-id {
 *                                     type uint32;
 *                                 }
 *                                 leaf interface-id {
 *                                     type uint32;
 *                                 }
 *                                 uses unnumbered-subobject;
 *                             }
 *                         }
 *                     }
 *                     uses exclude-route-subobjects;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses svec-object;
 *             uses exclude-route-object;
 *             uses gc-object;
 *             uses of-object;
 *             uses vendor-information-objects;
 *         }
 *         container monitoring-request {
 *             list pce-id-list {
 *                 key     container pce-id {
 *                     leaf ip-address {
 *                         type ip-address;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses pce-id-object;
 *             }
 *             container pcc-id-req {
 *                 leaf ip-address {
 *                     type ip-address;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container monitoring {
 *                 leaf flags {
 *                     type bits;
 *                 }
 *                 leaf monitoring-id {
 *                     type uint32;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         key     leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses monitoring;
 *         }
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 *     uses pcreq-message;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-message/pcmonreq</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcmonreqBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcmonreqBuilder
 *
 */
public interface Pcmonreq
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcmonreq>,
    PcreqMessage,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:message",
        "2013-10-07", "pcmonreq").intern();


}

