package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message.CCloseMessage;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping close-message {
 *     container c-close-message {
 *         leaf version {
 *             type version;
 *         }
 *         container c-close {
 *             leaf reason {
 *                 type uint8;
 *             }
 *             container tlvs {
 *                 list vendor-information-tlv {
 *                     key     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses message-header;
 *         uses close-object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/close-message</i>
 *
 */
public interface CloseMessage
    extends
    DataObject,
    Message
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "close-message").intern();

    /**
     * Close Message
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message.CCloseMessage</code> <code>cCloseMessage</code>, or <code>null</code> if not present
     */
    CCloseMessage getCCloseMessage();

}

