package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.metrics.MetricPce;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping monitoring-metrics {
 *     list metric-pce {
 *         key     container pce-id {
 *             leaf ip-address {
 *                 type ip-address;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         container proc-time {
 *             leaf estimated {
 *                 type boolean;
 *             }
 *             leaf current-proc-time {
 *                 type uint32;
 *             }
 *             leaf min-proc-time {
 *                 type uint32;
 *             }
 *             leaf max-proc-time {
 *                 type uint32;
 *             }
 *             leaf average-proc-time {
 *                 type uint32;
 *             }
 *             leaf variance-proc-time {
 *                 type uint32;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         container overload {
 *             leaf duration {
 *                 type uint16;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses overload-object;
 *         uses pce-id-object;
 *         uses proc-time-object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/monitoring-metrics</i>
 *
 */
public interface MonitoringMetrics
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "monitoring-metrics").intern();

    /**
     * @return <code>java.util.List</code> <code>metricPce</code>, or <code>null</code> if not present
     */
    List<MetricPce> getMetricPce();

}

