package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping open-message {
 *     container open-message {
 *         leaf version {
 *             type version;
 *         }
 *         container open {
 *             container tlvs {
 *                 list vendor-information-tlv {
 *                     key     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 container of-list {
 *                     leaf-list codes {
 *                         type of-id;
 *                     }
 *                     uses tlv;
 *                 }
 *                 uses of-list-tlv;
 *                 uses vendor-information-tlvs;
 *             }
 *             leaf version {
 *                 type version;
 *             }
 *             leaf keepalive {
 *                 type uint8;
 *             }
 *             leaf dead-timer {
 *                 type uint8;
 *             }
 *             leaf session-id {
 *                 type uint8;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses message-header;
 *         uses open-object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/open-message</i>
 *
 */
public interface OpenMessage
    extends
    DataObject,
    Message
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "open-message").intern();

    /**
     * Open Message
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message.OpenMessage</code> <code>openMessage</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message.OpenMessage getOpenMessage();

}

