package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping pcntf-message {
 *     container pcntf-message {
 *         leaf version {
 *             type version;
 *         }
 *         list notifications {
 *             key     list rps {
 *                 key     container rp {
 *                     container tlvs {
 *                         list vendor-information-tlv {
 *                             key     leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         container path-setup-type {
 *                             leaf pst {
 *                                 type pst;
 *                             }
 *                             uses tlv;
 *                         }
 *                         container order {
 *                             leaf delete {
 *                                 type uint32;
 *                             }
 *                             leaf setup {
 *                                 type uint32;
 *                             }
 *                             uses tlv;
 *                         }
 *                         uses vendor-information-tlvs;
 *                         uses order-tlv;
 *                         uses path-setup-type-tlv;
 *                     }
 *                     leaf priority {
 *                         type uint8;
 *                     }
 *                     leaf request-id {
 *                         type request-id;
 *                     }
 *                     leaf reoptimization {
 *                         type reoptimization;
 *                     }
 *                     leaf bi-directional {
 *                         type bi-directional;
 *                     }
 *                     leaf loose {
 *                         type loose;
 *                     }
 *                     leaf path-key {
 *                         type path-key;
 *                     }
 *                     leaf fragmentation {
 *                         type fragmentation;
 *                     }
 *                     leaf p2mp {
 *                         type p2mp;
 *                     }
 *                     leaf ero-compression {
 *                         type ero-compression;
 *                     }
 *                     leaf supply-of {
 *                         type supply-of;
 *                     }
 *                     leaf order {
 *                         type order;
 *                     }
 *                     leaf make-before-break {
 *                         type make-before-break;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses rp-object;
 *             }
 *             list notifications {
 *                 key     container c-notification {
 *                     container tlvs {
 *                         list vendor-information-tlv {
 *                             key     leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         container overload-duration {
 *                             leaf duration {
 *                                 type duration;
 *                             }
 *                             uses tlv;
 *                         }
 *                         uses vendor-information-tlvs;
 *                         uses overload-duration-tlv;
 *                     }
 *                     leaf type {
 *                         type uint8;
 *                     }
 *                     leaf value {
 *                         type uint8;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses notification-object;
 *             }
 *         }
 *         uses message-header;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcntf-message</i>
 *
 */
public interface PcntfMessage
    extends
    DataObject,
    Message
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "pcntf-message").intern();

    /**
     * Notification Message
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.PcntfMessage</code> <code>pcntfMessage</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.PcntfMessage getPcntfMessage();

}

