package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;

/**
 * RP Object
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping rp-object {
 *     container rp {
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         container tlvs {
 *             container order {
 *                 leaf delete {
 *                     type uint32;
 *                 }
 *                 leaf setup {
 *                     type uint32;
 *                 }
 *                 uses tlv;
 *             }
 *             list vendor-information-tlv {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             container path-setup-type {
 *                 leaf pst {
 *                     type pst;
 *                 }
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *             uses order-tlv;
 *             uses path-setup-type-tlv;
 *         }
 *         leaf priority {
 *             type uint8;
 *         }
 *         leaf request-id {
 *             type request-id;
 *         }
 *         leaf reoptimization {
 *             type reoptimization;
 *         }
 *         leaf bi-directional {
 *             type bi-directional;
 *         }
 *         leaf loose {
 *             type loose;
 *         }
 *         leaf path-key {
 *             type path-key;
 *         }
 *         leaf fragmentation {
 *             type fragmentation;
 *         }
 *         leaf p2mp {
 *             type p2mp;
 *         }
 *         leaf ero-compression {
 *             type ero-compression;
 *         }
 *         leaf supply-of {
 *             type supply-of;
 *         }
 *         leaf order {
 *             type order;
 *         }
 *         leaf make-before-break {
 *             type make-before-break;
 *         }
 *         uses object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/rp-object</i>
 *
 */
public interface RpObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "rp-object").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp</code> <code>rp</code>, or <code>null</code> if not present
     */
    Rp getRp();

}

