package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping start-tls-message {
 *     container start-tls-message {
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/start-tls-message</i>
 *
 */
public interface StartTlsMessage
    extends
    DataObject,
    Message
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "start-tls-message").intern();

    /**
     * StartTLS Message
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.start.tls.message.StartTlsMessage</code> <code>startTlsMessage</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.start.tls.message.StartTlsMessage getStartTlsMessage();

}

