package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.Svec;

/**
 * Synchronization Vector Object
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping svec-object {
 *     container svec {
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         leaf link-diverse {
 *             type link-diverse;
 *         }
 *         leaf node-diverse {
 *             type node-diverse;
 *         }
 *         leaf srlg-diverse {
 *             type srlg-diverse;
 *         }
 *         leaf-list requests-ids {
 *             type request-id;
 *         }
 *         uses object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/svec-object</i>
 *
 */
public interface SvecObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "svec-object").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.Svec</code> <code>svec</code>, or <code>null</code> if not present
     */
    Svec getSvec();

}

