package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.CloseObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.CloseMessage;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * Close Message
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container c-close-message {
 *     leaf version {
 *         type version;
 *     }
 *     container c-close {
 *         leaf reason {
 *             type uint8;
 *         }
 *         container tlvs {
 *             list vendor-information-tlv {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses object;
 *     }
 *     uses message-header;
 *     uses close-object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/close-message/c-close-message</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message.CCloseMessageBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message.CCloseMessageBuilder
 *
 */
public interface CCloseMessage
    extends
    ChildOf<CloseMessage>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.close.message.CCloseMessage>,
    MessageHeader,
    CloseObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "c-close-message").intern();


}

