package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.ero.Subobject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExplicitRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container ero {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     list subobject {
 *         key     leaf loose {
 *             type boolean;
 *         }
 *         choice subobject-type {
 *             case as-number-case {
 *                 container as-number {
 *                     leaf as-number {
 *                         type as-number;
 *                     }
 *                     uses as-number-subobject;
 *                 }
 *             }
 *             case exrs-case {
 *                 container exrs {
 *                     list exrs {
 *                         key     leaf mandatory {
 *                             type mandatory;
 *                         }
 *                         leaf attribute {
 *                             type enumeration;
 *                         }
 *                         choice subobject-type {
 *                             case as-number-case {
 *                                 container as-number {
 *                                     leaf as-number {
 *                                         type as-number;
 *                                     }
 *                                     uses as-number-subobject;
 *                                 }
 *                             }
 *                             case ip-prefix-case {
 *                                 container ip-prefix {
 *                                     leaf ip-prefix {
 *                                         type ip-prefix;
 *                                     }
 *                                     uses ip-prefix-subobject;
 *                                 }
 *                             }
 *                             case label-case {
 *                                 container label {
 *                                     leaf uni-directional {
 *                                         type boolean;
 *                                     }
 *                                     choice label-type {
 *                                         case generalized-label-case {
 *                                             container generalized-label {
 *                                                 leaf generalized-label {
 *                                                     type binary;
 *                                                 }
 *                                                 uses generalized-label;
 *                                             }
 *                                         }
 *                                         case type1-label-case {
 *                                             container type1-label {
 *                                                 leaf type1-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses type1-label;
 *                                             }
 *                                         }
 *                                         case waveband-switching-label-case {
 *                                             container waveband-switching-label {
 *                                                 leaf end-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf start-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf waveband-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses waveband-switching-label;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses label-subobject;
 *                                 }
 *                             }
 *                             case srlg-case {
 *                                 container srlg {
 *                                     leaf srlg-id {
 *                                         type srlg-id;
 *                                     }
 *                                     uses srlg-subobject;
 *                                 }
 *                             }
 *                             case unnumbered-case {
 *                                 container unnumbered {
 *                                     leaf router-id {
 *                                         type uint32;
 *                                     }
 *                                     leaf interface-id {
 *                                         type uint32;
 *                                     }
 *                                     uses unnumbered-subobject;
 *                                 }
 *                             }
 *                         }
 *                         uses exclude-route-subobjects;
 *                     }
 *                 }
 *             }
 *             case ip-prefix-case {
 *                 container ip-prefix {
 *                     leaf ip-prefix {
 *                         type ip-prefix;
 *                     }
 *                     uses ip-prefix-subobject;
 *                 }
 *             }
 *             case label-case {
 *                 container label {
 *                     leaf uni-directional {
 *                         type boolean;
 *                     }
 *                     choice label-type {
 *                         case generalized-label-case {
 *                             container generalized-label {
 *                                 leaf generalized-label {
 *                                     type binary;
 *                                 }
 *                                 uses generalized-label;
 *                             }
 *                         }
 *                         case type1-label-case {
 *                             container type1-label {
 *                                 leaf type1-label {
 *                                     type uint32;
 *                                 }
 *                                 uses type1-label;
 *                             }
 *                         }
 *                         case waveband-switching-label-case {
 *                             container waveband-switching-label {
 *                                 leaf end-label {
 *                                     type uint32;
 *                                 }
 *                                 leaf start-label {
 *                                     type uint32;
 *                                 }
 *                                 leaf waveband-id {
 *                                     type uint32;
 *                                 }
 *                                 uses waveband-switching-label;
 *                             }
 *                         }
 *                     }
 *                     uses label-subobject;
 *                 }
 *             }
 *             case path-key-case {
 *                 container path-key {
 *                     leaf pce-id {
 *                         type pce-id;
 *                     }
 *                     leaf path-key {
 *                         type path-key;
 *                     }
 *                     uses path-key-subobject;
 *                 }
 *             }
 *             case srlg-case {
 *                 container srlg {
 *                     leaf srlg-id {
 *                         type srlg-id;
 *                     }
 *                     uses srlg-subobject;
 *                 }
 *             }
 *             case unnumbered-case {
 *                 container unnumbered {
 *                     leaf router-id {
 *                         type uint32;
 *                     }
 *                     leaf interface-id {
 *                         type uint32;
 *                     }
 *                     uses unnumbered-subobject;
 *                 }
 *             }
 *         }
 *         uses explicit-route-subobjects;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/explicit-route-object/ero</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.EroBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.EroBuilder
 *
 */
public interface Ero
    extends
    ChildOf<ExplicitRouteObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.explicit.route.object.Ero>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "ero").intern();

    /**
     * @return <code>java.util.List</code> <code>subobject</code>, or <code>null</code> if not present
     */
    List<Subobject> getSubobject();

}

