package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.lspa.Tlvs;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa
 *
 */
public class LspaBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa> {

    private AttributeFilter _excludeAny;
    private java.lang.Short _holdPriority;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private java.lang.String _sessionName;
    private java.lang.Short _setupPriority;
    private Tlvs _tlvs;
    private java.lang.Boolean _ignore;
    private java.lang.Boolean _labelRecordingDesired;
    private java.lang.Boolean _localProtectionDesired;
    private java.lang.Boolean _processingRule;
    private java.lang.Boolean _seStyleDesired;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>> augmentation = Collections.emptyMap();

    public LspaBuilder() {
    }
    public LspaBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes arg) {
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public LspaBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }
    public LspaBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public LspaBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public LspaBuilder(Lspa base) {
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._labelRecordingDesired = base.isLabelRecordingDesired();
        this._localProtectionDesired = base.isLocalProtectionDesired();
        this._processingRule = base.isProcessingRule();
        this._seStyleDesired = base.isSeStyleDesired();
        if (base instanceof LspaImpl) {
            LspaImpl impl = (LspaImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters) {
            this._includeAny = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority) {
            this._holdPriority = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority)arg).getHoldPriority();
            this._setupPriority = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes) {
            this._localProtectionDesired = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).isLocalProtectionDesired();
            this._labelRecordingDesired = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).isLabelRecordingDesired();
            this._seStyleDesired = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).isSeStyleDesired();
            this._sessionName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).getSessionName();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader) {
            this._processingRule = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isProcessingRule();
            this._ignore = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \n" +
              "but was: " + arg
            );
        }
    }

    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    public java.lang.Short getHoldPriority() {
        return _holdPriority;
    }
    
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    public java.lang.String getSessionName() {
        return _sessionName;
    }
    
    public java.lang.Short getSetupPriority() {
        return _setupPriority;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }
    
    public java.lang.Boolean isIgnore() {
        return _ignore;
    }
    
    public java.lang.Boolean isLabelRecordingDesired() {
        return _labelRecordingDesired;
    }
    
    public java.lang.Boolean isLocalProtectionDesired() {
        return _localProtectionDesired;
    }
    
    public java.lang.Boolean isProcessingRule() {
        return _processingRule;
    }
    
    public java.lang.Boolean isSeStyleDesired() {
        return _seStyleDesired;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public LspaBuilder setExcludeAny(final AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }
    
     
     private static void checkHoldPriorityRange(final short value) {
         if (value >= (short)0 && value <= (short)255) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
     }
    
    public LspaBuilder setHoldPriority(final java.lang.Short value) {
    if (value != null) {
        checkHoldPriorityRange(value);
    }
        this._holdPriority = value;
        return this;
    }
    
     
    public LspaBuilder setIncludeAll(final AttributeFilter value) {
        this._includeAll = value;
        return this;
    }
    
     
    public LspaBuilder setIncludeAny(final AttributeFilter value) {
        this._includeAny = value;
        return this;
    }
    
     
    public LspaBuilder setSessionName(final java.lang.String value) {
        this._sessionName = value;
        return this;
    }
    
     
     private static void checkSetupPriorityRange(final short value) {
         if (value >= (short)0 && value <= (short)255) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
     }
    
    public LspaBuilder setSetupPriority(final java.lang.Short value) {
    if (value != null) {
        checkSetupPriorityRange(value);
    }
        this._setupPriority = value;
        return this;
    }
    
     
    public LspaBuilder setTlvs(final Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
     
    public LspaBuilder setIgnore(final java.lang.Boolean value) {
        this._ignore = value;
        return this;
    }
    
     
    public LspaBuilder setLabelRecordingDesired(final java.lang.Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }
    
     
    public LspaBuilder setLocalProtectionDesired(final java.lang.Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }
    
     
    public LspaBuilder setProcessingRule(final java.lang.Boolean value) {
        this._processingRule = value;
        return this;
    }
    
     
    public LspaBuilder setSeStyleDesired(final java.lang.Boolean value) {
        this._seStyleDesired = value;
        return this;
    }
    
    public LspaBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public LspaBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Lspa build() {
        return new LspaImpl(this);
    }

    private static final class LspaImpl implements Lspa {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa.class;
        }

        private final AttributeFilter _excludeAny;
        private final java.lang.Short _holdPriority;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final java.lang.String _sessionName;
        private final java.lang.Short _setupPriority;
        private final Tlvs _tlvs;
        private final java.lang.Boolean _ignore;
        private final java.lang.Boolean _labelRecordingDesired;
        private final java.lang.Boolean _localProtectionDesired;
        private final java.lang.Boolean _processingRule;
        private final java.lang.Boolean _seStyleDesired;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>> augmentation = Collections.emptyMap();

        private LspaImpl(LspaBuilder base) {
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._labelRecordingDesired = base.isLabelRecordingDesired();
            this._localProtectionDesired = base.isLocalProtectionDesired();
            this._processingRule = base.isProcessingRule();
            this._seStyleDesired = base.isSeStyleDesired();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public java.lang.Short getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public java.lang.String getSessionName() {
            return _sessionName;
        }
        
        @Override
        public java.lang.Short getSetupPriority() {
            return _setupPriority;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
        
        @Override
        public java.lang.Boolean isIgnore() {
            return _ignore;
        }
        
        @Override
        public java.lang.Boolean isLabelRecordingDesired() {
            return _labelRecordingDesired;
        }
        
        @Override
        public java.lang.Boolean isLocalProtectionDesired() {
            return _localProtectionDesired;
        }
        
        @Override
        public java.lang.Boolean isProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public java.lang.Boolean isSeStyleDesired() {
            return _seStyleDesired;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_excludeAny);
            result = prime * result + Objects.hashCode(_holdPriority);
            result = prime * result + Objects.hashCode(_includeAll);
            result = prime * result + Objects.hashCode(_includeAny);
            result = prime * result + Objects.hashCode(_sessionName);
            result = prime * result + Objects.hashCode(_setupPriority);
            result = prime * result + Objects.hashCode(_tlvs);
            result = prime * result + Objects.hashCode(_ignore);
            result = prime * result + Objects.hashCode(_labelRecordingDesired);
            result = prime * result + Objects.hashCode(_localProtectionDesired);
            result = prime * result + Objects.hashCode(_processingRule);
            result = prime * result + Objects.hashCode(_seStyleDesired);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa)obj;
            if (!Objects.equals(_excludeAny, other.getExcludeAny())) {
                return false;
            }
            if (!Objects.equals(_holdPriority, other.getHoldPriority())) {
                return false;
            }
            if (!Objects.equals(_includeAll, other.getIncludeAll())) {
                return false;
            }
            if (!Objects.equals(_includeAny, other.getIncludeAny())) {
                return false;
            }
            if (!Objects.equals(_sessionName, other.getSessionName())) {
                return false;
            }
            if (!Objects.equals(_setupPriority, other.getSetupPriority())) {
                return false;
            }
            if (!Objects.equals(_tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(_ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(_labelRecordingDesired, other.isLabelRecordingDesired())) {
                return false;
            }
            if (!Objects.equals(_localProtectionDesired, other.isLocalProtectionDesired())) {
                return false;
            }
            if (!Objects.equals(_processingRule, other.isProcessingRule())) {
                return false;
            }
            if (!Objects.equals(_seStyleDesired, other.isSeStyleDesired())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                LspaImpl otherImpl = (LspaImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "Lspa [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_excludeAny != null) {
                builder.append("_excludeAny=");
                builder.append(_excludeAny);
                builder.append(", ");
            }
            if (_holdPriority != null) {
                builder.append("_holdPriority=");
                builder.append(_holdPriority);
                builder.append(", ");
            }
            if (_includeAll != null) {
                builder.append("_includeAll=");
                builder.append(_includeAll);
                builder.append(", ");
            }
            if (_includeAny != null) {
                builder.append("_includeAny=");
                builder.append(_includeAny);
                builder.append(", ");
            }
            if (_sessionName != null) {
                builder.append("_sessionName=");
                builder.append(_sessionName);
                builder.append(", ");
            }
            if (_setupPriority != null) {
                builder.append("_setupPriority=");
                builder.append(_setupPriority);
                builder.append(", ");
            }
            if (_tlvs != null) {
                builder.append("_tlvs=");
                builder.append(_tlvs);
                builder.append(", ");
            }
            if (_ignore != null) {
                builder.append("_ignore=");
                builder.append(_ignore);
                builder.append(", ");
            }
            if (_labelRecordingDesired != null) {
                builder.append("_labelRecordingDesired=");
                builder.append(_labelRecordingDesired);
                builder.append(", ");
            }
            if (_localProtectionDesired != null) {
                builder.append("_localProtectionDesired=");
                builder.append(_localProtectionDesired);
                builder.append(", ");
            }
            if (_processingRule != null) {
                builder.append("_processingRule=");
                builder.append(_processingRule);
                builder.append(", ");
            }
            if (_seStyleDesired != null) {
                builder.append("_seStyleDesired=");
                builder.append(_seStyleDesired);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
