package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MetricObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container metric {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     leaf metric-type {
 *         type uint8;
 *     }
 *     leaf bound {
 *         type bound;
 *     }
 *     leaf computed {
 *         type computed;
 *     }
 *     leaf value {
 *         type float32;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/metric-object/metric</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.MetricBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.MetricBuilder
 *
 */
public interface Metric
    extends
    ChildOf<MetricObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "metric").intern();

    /**
     * @return <code>java.lang.Short</code> <code>metricType</code>, or <code>null</code> if not present
     */
    java.lang.Short getMetricType();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>bound</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isBound();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>computed</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isComputed();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32</code> <code>value</code>, or <code>null</code> if not present
     */
    Float32 getValue();

}

