package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.of.Tlvs;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container of {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     leaf code {
 *         type of-id;
 *     }
 *     container tlvs {
 *         list vendor-information-tlv {
 *             key     leaf enterprise-number {
 *                 type enterprise-number;
 *             }
 *             choice enterprise-specific-information {
 *             }
 *             uses vendor-information;
 *             uses tlv;
 *         }
 *         uses vendor-information-tlvs;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/of-object/of</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.OfBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.OfBuilder
 *
 */
public interface Of
    extends
    ChildOf<OfObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.Of>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "of").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfId</code> <code>code</code>, or <code>null</code> if not present
     */
    OfId getCode();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.of.Tlvs</code> <code>tlvs</code>, or <code>null</code> if not present
     */
    Tlvs getTlvs();

}

