package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfListTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container tlvs {
 *     container of-list {
 *         leaf-list codes {
 *             type of-id;
 *         }
 *         uses tlv;
 *     }
 *     list vendor-information-tlv {
 *         key     leaf enterprise-number {
 *             type enterprise-number;
 *         }
 *         choice enterprise-specific-information {
 *         }
 *         uses vendor-information;
 *         uses tlv;
 *     }
 *     uses of-list-tlv;
 *     uses vendor-information-tlvs;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/open-object/open/tlvs</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.TlvsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.TlvsBuilder
 *
 */
public interface Tlvs
    extends
    ChildOf<Open>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.Tlvs>,
    OfListTlv,
    VendorInformationTlvs
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "tlvs").intern();


}

