package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.PathKey;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKeySubobject;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list path-keys {
 *     key     leaf loose {
 *         type loose;
 *     }
 *     leaf pce-id {
 *         type pce-id;
 *     }
 *     leaf path-key {
 *         type path-key;
 *     }
 *     uses path-key-subobject;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/path-key-object/path-key/path-keys</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key.PathKeysBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key.PathKeysBuilder
 *
 *
 */
public interface PathKeys
    extends
    ChildOf<PathKey>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key.PathKeys>,
    PathKeySubobject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "path-keys").intern();

    /**
     * @return <code>java.lang.Boolean</code> <code>loose</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isLoose();

}

