package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.error.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReqMissingTlv;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container tlvs {
 *     container req-missing {
 *         leaf request-id {
 *             type request-id;
 *         }
 *         uses tlv;
 *     }
 *     list vendor-information-tlv {
 *         key     leaf enterprise-number {
 *             type enterprise-number;
 *         }
 *         choice enterprise-specific-information {
 *         }
 *         uses vendor-information;
 *         uses tlv;
 *     }
 *     uses vendor-information-tlvs;
 *     uses req-missing-tlv;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcep-error-object/error-object/tlvs</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.error.object.TlvsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.error.object.TlvsBuilder
 *
 */
public interface Tlvs
    extends
    ChildOf<ErrorObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.error.object.Tlvs>,
    VendorInformationTlvs,
    ReqMissingTlv
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "tlvs").intern();


}

