package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.SvecObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.GcObject;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.svec.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.PcreqMessage;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list svec {
 *     key     container svec {
 *         leaf link-diverse {
 *             type link-diverse;
 *         }
 *         leaf node-diverse {
 *             type node-diverse;
 *         }
 *         leaf srlg-diverse {
 *             type srlg-diverse;
 *         }
 *         leaf-list requests-ids {
 *             type request-id;
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses object;
 *     }
 *     container of {
 *         leaf code {
 *             type of-id;
 *         }
 *         container tlvs {
 *             list vendor-information-tlv {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses object;
 *     }
 *     container gc {
 *         leaf max-hop {
 *             type uint8;
 *         }
 *         leaf max-utilization {
 *             type max-utilization;
 *         }
 *         leaf min-utilization {
 *             type min-utilization;
 *         }
 *         leaf over-booking-factor {
 *             type over-booking-factor;
 *         }
 *         container tlvs {
 *             list vendor-information-tlv {
 *                 key     leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses object;
 *     }
 *     container xro {
 *         leaf flags {
 *             type bits;
 *         }
 *         list subobject {
 *             key     leaf mandatory {
 *                 type mandatory;
 *             }
 *             leaf attribute {
 *                 type enumeration;
 *             }
 *             choice subobject-type {
 *                 case as-number-case {
 *                     container as-number {
 *                         leaf as-number {
 *                             type as-number;
 *                         }
 *                         uses as-number-subobject;
 *                     }
 *                 }
 *                 case ip-prefix-case {
 *                     container ip-prefix {
 *                         leaf ip-prefix {
 *                             type ip-prefix;
 *                         }
 *                         uses ip-prefix-subobject;
 *                     }
 *                 }
 *                 case label-case {
 *                     container label {
 *                         leaf uni-directional {
 *                             type boolean;
 *                         }
 *                         choice label-type {
 *                             case generalized-label-case {
 *                                 container generalized-label {
 *                                     leaf generalized-label {
 *                                         type binary;
 *                                     }
 *                                     uses generalized-label;
 *                                 }
 *                             }
 *                             case type1-label-case {
 *                                 container type1-label {
 *                                     leaf type1-label {
 *                                         type uint32;
 *                                     }
 *                                     uses type1-label;
 *                                 }
 *                             }
 *                             case waveband-switching-label-case {
 *                                 container waveband-switching-label {
 *                                     leaf end-label {
 *                                         type uint32;
 *                                     }
 *                                     leaf start-label {
 *                                         type uint32;
 *                                     }
 *                                     leaf waveband-id {
 *                                         type uint32;
 *                                     }
 *                                     uses waveband-switching-label;
 *                                 }
 *                             }
 *                         }
 *                         uses label-subobject;
 *                     }
 *                 }
 *                 case srlg-case {
 *                     container srlg {
 *                         leaf srlg-id {
 *                             type srlg-id;
 *                         }
 *                         uses srlg-subobject;
 *                     }
 *                 }
 *                 case unnumbered-case {
 *                     container unnumbered {
 *                         leaf router-id {
 *                             type uint32;
 *                         }
 *                         leaf interface-id {
 *                             type uint32;
 *                         }
 *                         uses unnumbered-subobject;
 *                     }
 *                 }
 *             }
 *             uses exclude-route-subobjects;
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses object;
 *     }
 *     list metric {
 *         key     container metric {
 *             leaf metric-type {
 *                 type uint8;
 *             }
 *             leaf bound {
 *                 type bound;
 *             }
 *             leaf computed {
 *                 type computed;
 *             }
 *             leaf value {
 *                 type float32;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses metric-object;
 *     }
 *     list vendor-information-object {
 *         key     leaf enterprise-number {
 *             type enterprise-number;
 *         }
 *         choice enterprise-specific-information {
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses vendor-information;
 *         uses object;
 *     }
 *     uses svec-object;
 *     uses exclude-route-object;
 *     uses gc-object;
 *     uses of-object;
 *     uses vendor-information-objects;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcreq-message/pcreq-message/svec</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.SvecBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.SvecBuilder
 *
 *
 */
public interface Svec
    extends
    ChildOf<PcreqMessage>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec>,
    SvecObject,
    ExcludeRouteObject,
    GcObject,
    OfObject,
    VendorInformationObjects
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "svec").intern();

    /**
     * @return <code>java.util.List</code> <code>metric</code>, or <code>null</code> if not present
     */
    List<Metric> getMetric();

}

