package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.Rro;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;
import java.util.Objects;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import java.util.Collections;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.p2p.ReportedRoute;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p
 *
 */
public class P2pBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p> {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private EndpointsObj _endpointsObj;
    private Iro _iro;
    private LoadBalancing _loadBalancing;
    private Lspa _lspa;
    private List<Metrics> _metrics;
    private Of _of;
    private ReoptimizationBandwidth _reoptimizationBandwidth;
    private ReportedRoute _reportedRoute;
    private Rro _rro;
    private List<VendorInformationObject> _vendorInformationObject;
    private Xro _xro;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> augmentation = Collections.emptyMap();

    public P2pBuilder() {
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject arg) {
        this._endpointsObj = arg.getEndpointsObj();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects arg) {
        this._vendorInformationObject = arg.getVendorInformationObject();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LoadBalancingObject arg) {
        this._loadBalancing = arg.getLoadBalancing();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes arg) {
        this._metrics = arg.getMetrics();
        this._lspa = arg.getLspa();
        this._xro = arg.getXro();
        this._bandwidth = arg.getBandwidth();
        this._iro = arg.getIro();
        this._classType = arg.getClassType();
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
        this._of = arg.getOf();
        this._rro = arg.getRro();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject arg) {
        this._lspa = arg.getLspa();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject arg) {
        this._xro = arg.getXro();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject arg) {
        this._iro = arg.getIro();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject arg) {
        this._classType = arg.getClassType();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReoptimizationBandwidthObject arg) {
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject arg) {
        this._of = arg.getOf();
    }
    public P2pBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject arg) {
        this._rro = arg.getRro();
    }

    public P2pBuilder(P2p base) {
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._endpointsObj = base.getEndpointsObj();
        this._iro = base.getIro();
        this._loadBalancing = base.getLoadBalancing();
        this._lspa = base.getLspa();
        this._metrics = base.getMetrics();
        this._of = base.getOf();
        this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
        this._reportedRoute = base.getReportedRoute();
        this._rro = base.getRro();
        this._vendorInformationObject = base.getVendorInformationObject();
        this._xro = base.getXro();
        if (base instanceof P2pImpl) {
            P2pImpl impl = (P2pImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReoptimizationBandwidthObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LoadBalancingObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject) {
            this._endpointsObj = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject)arg).getEndpointsObj();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject) {
            this._iro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject)arg).getIro();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReoptimizationBandwidthObject) {
            this._reoptimizationBandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReoptimizationBandwidthObject)arg).getReoptimizationBandwidth();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects) {
            this._vendorInformationObject = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects)arg).getVendorInformationObject();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LoadBalancingObject) {
            this._loadBalancing = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LoadBalancingObject)arg).getLoadBalancing();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject) {
            this._bandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes) {
            this._metrics = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes)arg).getMetrics();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject) {
            this._lspa = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject)arg).getLspa();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject) {
            this._xro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject)arg).getXro();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject) {
            this._classType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject)arg).getClassType();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject) {
            this._of = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject)arg).getOf();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject) {
            this._rro = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject)arg).getRro();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.EndpointsObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.IncludeRouteObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReoptimizationBandwidthObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LoadBalancingObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.BandwidthObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.LspaObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ExcludeRouteObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClasstypeObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject] \n" +
              "but was: " + arg
            );
        }
    }

    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    public ClassType getClassType() {
        return _classType;
    }
    
    public EndpointsObj getEndpointsObj() {
        return _endpointsObj;
    }
    
    public Iro getIro() {
        return _iro;
    }
    
    public LoadBalancing getLoadBalancing() {
        return _loadBalancing;
    }
    
    public Lspa getLspa() {
        return _lspa;
    }
    
    public List<Metrics> getMetrics() {
        return _metrics;
    }
    
    public Of getOf() {
        return _of;
    }
    
    public ReoptimizationBandwidth getReoptimizationBandwidth() {
        return _reoptimizationBandwidth;
    }
    
    public ReportedRoute getReportedRoute() {
        return _reportedRoute;
    }
    
    public Rro getRro() {
        return _rro;
    }
    
    public List<VendorInformationObject> getVendorInformationObject() {
        return _vendorInformationObject;
    }
    
    public Xro getXro() {
        return _xro;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public P2pBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
     
    public P2pBuilder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
     
    public P2pBuilder setEndpointsObj(final EndpointsObj value) {
        this._endpointsObj = value;
        return this;
    }
    
     
    public P2pBuilder setIro(final Iro value) {
        this._iro = value;
        return this;
    }
    
     
    public P2pBuilder setLoadBalancing(final LoadBalancing value) {
        this._loadBalancing = value;
        return this;
    }
    
     
    public P2pBuilder setLspa(final Lspa value) {
        this._lspa = value;
        return this;
    }
    
     
    public P2pBuilder setMetrics(final List<Metrics> value) {
        this._metrics = value;
        return this;
    }
    
     
    public P2pBuilder setOf(final Of value) {
        this._of = value;
        return this;
    }
    
     
    public P2pBuilder setReoptimizationBandwidth(final ReoptimizationBandwidth value) {
        this._reoptimizationBandwidth = value;
        return this;
    }
    
     
    public P2pBuilder setReportedRoute(final ReportedRoute value) {
        this._reportedRoute = value;
        return this;
    }
    
     
    public P2pBuilder setRro(final Rro value) {
        this._rro = value;
        return this;
    }
    
     
    public P2pBuilder setVendorInformationObject(final List<VendorInformationObject> value) {
        this._vendorInformationObject = value;
        return this;
    }
    
     
    public P2pBuilder setXro(final Xro value) {
        this._xro = value;
        return this;
    }
    
    public P2pBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public P2pBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public P2p build() {
        return new P2pImpl(this);
    }

    private static final class P2pImpl implements P2p {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p.class;
        }

        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final EndpointsObj _endpointsObj;
        private final Iro _iro;
        private final LoadBalancing _loadBalancing;
        private final Lspa _lspa;
        private final List<Metrics> _metrics;
        private final Of _of;
        private final ReoptimizationBandwidth _reoptimizationBandwidth;
        private final ReportedRoute _reportedRoute;
        private final Rro _rro;
        private final List<VendorInformationObject> _vendorInformationObject;
        private final Xro _xro;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> augmentation = Collections.emptyMap();

        private P2pImpl(P2pBuilder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._endpointsObj = base.getEndpointsObj();
            this._iro = base.getIro();
            this._loadBalancing = base.getLoadBalancing();
            this._lspa = base.getLspa();
            this._metrics = base.getMetrics();
            this._of = base.getOf();
            this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
            this._reportedRoute = base.getReportedRoute();
            this._rro = base.getRro();
            this._vendorInformationObject = base.getVendorInformationObject();
            this._xro = base.getXro();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public EndpointsObj getEndpointsObj() {
            return _endpointsObj;
        }
        
        @Override
        public Iro getIro() {
            return _iro;
        }
        
        @Override
        public LoadBalancing getLoadBalancing() {
            return _loadBalancing;
        }
        
        @Override
        public Lspa getLspa() {
            return _lspa;
        }
        
        @Override
        public List<Metrics> getMetrics() {
            return _metrics;
        }
        
        @Override
        public Of getOf() {
            return _of;
        }
        
        @Override
        public ReoptimizationBandwidth getReoptimizationBandwidth() {
            return _reoptimizationBandwidth;
        }
        
        @Override
        public ReportedRoute getReportedRoute() {
            return _reportedRoute;
        }
        
        @Override
        public Rro getRro() {
            return _rro;
        }
        
        @Override
        public List<VendorInformationObject> getVendorInformationObject() {
            return _vendorInformationObject;
        }
        
        @Override
        public Xro getXro() {
            return _xro;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_bandwidth);
            result = prime * result + Objects.hashCode(_classType);
            result = prime * result + Objects.hashCode(_endpointsObj);
            result = prime * result + Objects.hashCode(_iro);
            result = prime * result + Objects.hashCode(_loadBalancing);
            result = prime * result + Objects.hashCode(_lspa);
            result = prime * result + Objects.hashCode(_metrics);
            result = prime * result + Objects.hashCode(_of);
            result = prime * result + Objects.hashCode(_reoptimizationBandwidth);
            result = prime * result + Objects.hashCode(_reportedRoute);
            result = prime * result + Objects.hashCode(_rro);
            result = prime * result + Objects.hashCode(_vendorInformationObject);
            result = prime * result + Objects.hashCode(_xro);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p)obj;
            if (!Objects.equals(_bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(_classType, other.getClassType())) {
                return false;
            }
            if (!Objects.equals(_endpointsObj, other.getEndpointsObj())) {
                return false;
            }
            if (!Objects.equals(_iro, other.getIro())) {
                return false;
            }
            if (!Objects.equals(_loadBalancing, other.getLoadBalancing())) {
                return false;
            }
            if (!Objects.equals(_lspa, other.getLspa())) {
                return false;
            }
            if (!Objects.equals(_metrics, other.getMetrics())) {
                return false;
            }
            if (!Objects.equals(_of, other.getOf())) {
                return false;
            }
            if (!Objects.equals(_reoptimizationBandwidth, other.getReoptimizationBandwidth())) {
                return false;
            }
            if (!Objects.equals(_reportedRoute, other.getReportedRoute())) {
                return false;
            }
            if (!Objects.equals(_rro, other.getRro())) {
                return false;
            }
            if (!Objects.equals(_vendorInformationObject, other.getVendorInformationObject())) {
                return false;
            }
            if (!Objects.equals(_xro, other.getXro())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                P2pImpl otherImpl = (P2pImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "P2p [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_bandwidth != null) {
                builder.append("_bandwidth=");
                builder.append(_bandwidth);
                builder.append(", ");
            }
            if (_classType != null) {
                builder.append("_classType=");
                builder.append(_classType);
                builder.append(", ");
            }
            if (_endpointsObj != null) {
                builder.append("_endpointsObj=");
                builder.append(_endpointsObj);
                builder.append(", ");
            }
            if (_iro != null) {
                builder.append("_iro=");
                builder.append(_iro);
                builder.append(", ");
            }
            if (_loadBalancing != null) {
                builder.append("_loadBalancing=");
                builder.append(_loadBalancing);
                builder.append(", ");
            }
            if (_lspa != null) {
                builder.append("_lspa=");
                builder.append(_lspa);
                builder.append(", ");
            }
            if (_metrics != null) {
                builder.append("_metrics=");
                builder.append(_metrics);
                builder.append(", ");
            }
            if (_of != null) {
                builder.append("_of=");
                builder.append(_of);
                builder.append(", ");
            }
            if (_reoptimizationBandwidth != null) {
                builder.append("_reoptimizationBandwidth=");
                builder.append(_reoptimizationBandwidth);
                builder.append(", ");
            }
            if (_reportedRoute != null) {
                builder.append("_reportedRoute=");
                builder.append(_reportedRoute);
                builder.append(", ");
            }
            if (_rro != null) {
                builder.append("_rro=");
                builder.append(_rro);
                builder.append(", ");
            }
            if (_vendorInformationObject != null) {
                builder.append("_vendorInformationObject=");
                builder.append(_vendorInformationObject);
                builder.append(", ");
            }
            if (_xro != null) {
                builder.append("_xro=");
                builder.append(_xro);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
