package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.svec;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MetricObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list metric {
 *     key     container metric {
 *         leaf metric-type {
 *             type uint8;
 *         }
 *         leaf bound {
 *             type bound;
 *         }
 *         leaf computed {
 *             type computed;
 *         }
 *         leaf value {
 *             type float32;
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses object;
 *     }
 *     uses metric-object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcreq-message/pcreq-message/svec/metric</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.svec.MetricBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.svec.MetricBuilder
 *
 *
 */
public interface Metric
    extends
    ChildOf<Svec>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.svec.Metric>,
    MetricObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "metric").intern();


}

