package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProcTimeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container proc-time {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     leaf estimated {
 *         type boolean;
 *     }
 *     leaf current-proc-time {
 *         type uint32;
 *     }
 *     leaf min-proc-time {
 *         type uint32;
 *     }
 *     leaf max-proc-time {
 *         type uint32;
 *     }
 *     leaf average-proc-time {
 *         type uint32;
 *     }
 *     leaf variance-proc-time {
 *         type uint32;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/proc-time-object/proc-time</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTimeBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTimeBuilder
 *
 */
public interface ProcTime
    extends
    ChildOf<ProcTimeObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "proc-time").intern();

    /**
     * Indicates that the reported metric value is based on estimated processing time 
     * as opposed to actual computations.
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>estimated</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isEstimated();
    
    /**
     * Indicates, in milliseconds, the processing time for the path computation of 
     * interest characterized in the corresponding PCMonReq message.
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>currentProcTime</code>, or <code>null</code> if not present
     */
    java.lang.Long getCurrentProcTime();
    
    /**
     * The minimum processing time in milliseconds
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>minProcTime</code>, or <code>null</code> if not present
     */
    java.lang.Long getMinProcTime();
    
    /**
     * The maximum processing time in milliseconds
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>maxProcTime</code>, or <code>null</code> if not present
     */
    java.lang.Long getMaxProcTime();
    
    /**
     * The average processing time in milliseconds
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>averageProcTime</code>, or <code>null</code> if not present
     */
    java.lang.Long getAverageProcTime();
    
    /**
     * The variance of processing times in milliseconds
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>varianceProcTime</code>, or <code>null</code> if not present
     */
    java.lang.Long getVarianceProcTime();

}

