package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.Subobject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ReportedRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container rro {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     list subobject {
 *         key     leaf protection-available {
 *             type protection-available;
 *         }
 *         leaf protection-in-use {
 *             type protection-in-use;
 *         }
 *         choice subobject-type {
 *             case ip-prefix-case {
 *                 container ip-prefix {
 *                     leaf ip-prefix {
 *                         type ip-prefix;
 *                     }
 *                     uses ip-prefix-subobject;
 *                 }
 *             }
 *             case label-case {
 *                 container label {
 *                     leaf global {
 *                         type global;
 *                     }
 *                     leaf uni-directional {
 *                         type boolean;
 *                     }
 *                     choice label-type {
 *                         case generalized-label-case {
 *                             container generalized-label {
 *                                 leaf generalized-label {
 *                                     type binary;
 *                                 }
 *                                 uses generalized-label;
 *                             }
 *                         }
 *                         case type1-label-case {
 *                             container type1-label {
 *                                 leaf type1-label {
 *                                     type uint32;
 *                                 }
 *                                 uses type1-label;
 *                             }
 *                         }
 *                         case waveband-switching-label-case {
 *                             container waveband-switching-label {
 *                                 leaf end-label {
 *                                     type uint32;
 *                                 }
 *                                 leaf start-label {
 *                                     type uint32;
 *                                 }
 *                                 leaf waveband-id {
 *                                     type uint32;
 *                                 }
 *                                 uses waveband-switching-label;
 *                             }
 *                         }
 *                     }
 *                     uses label-subobject;
 *                 }
 *             }
 *             case path-key-case {
 *                 container path-key {
 *                     leaf pce-id {
 *                         type pce-id;
 *                     }
 *                     leaf path-key {
 *                         type path-key;
 *                     }
 *                     uses path-key-subobject;
 *                 }
 *             }
 *             case unnumbered-case {
 *                 container unnumbered {
 *                     leaf router-id {
 *                         type uint32;
 *                     }
 *                     leaf interface-id {
 *                         type uint32;
 *                     }
 *                     uses unnumbered-subobject;
 *                 }
 *             }
 *         }
 *         uses record-route-subobjects;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/reported-route-object/rro</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.RroBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.RroBuilder
 *
 */
public interface Rro
    extends
    ChildOf<ReportedRouteObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.Rro>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "rro").intern();

    /**
     * @return <code>java.util.List</code> <code>subobject</code>, or <code>null</code> if not present
     */
    List<Subobject> getSubobject();

}

