package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RpObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container rp {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     container tlvs {
 *         container order {
 *             leaf delete {
 *                 type uint32;
 *             }
 *             leaf setup {
 *                 type uint32;
 *             }
 *             uses tlv;
 *         }
 *         list vendor-information-tlv {
 *             key     leaf enterprise-number {
 *                 type enterprise-number;
 *             }
 *             choice enterprise-specific-information {
 *             }
 *             uses vendor-information;
 *             uses tlv;
 *         }
 *         container path-setup-type {
 *             leaf pst {
 *                 type pst;
 *             }
 *             uses tlv;
 *         }
 *         uses vendor-information-tlvs;
 *         uses order-tlv;
 *         uses path-setup-type-tlv;
 *     }
 *     leaf priority {
 *         type uint8;
 *     }
 *     leaf request-id {
 *         type request-id;
 *     }
 *     leaf reoptimization {
 *         type reoptimization;
 *     }
 *     leaf bi-directional {
 *         type bi-directional;
 *     }
 *     leaf loose {
 *         type loose;
 *     }
 *     leaf path-key {
 *         type path-key;
 *     }
 *     leaf fragmentation {
 *         type fragmentation;
 *     }
 *     leaf p2mp {
 *         type p2mp;
 *     }
 *     leaf ero-compression {
 *         type ero-compression;
 *     }
 *     leaf supply-of {
 *         type supply-of;
 *     }
 *     leaf order {
 *         type order;
 *     }
 *     leaf make-before-break {
 *         type make-before-break;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/rp-object/rp</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.RpBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.RpBuilder
 *
 */
public interface Rp
    extends
    ChildOf<RpObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "rp").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.Tlvs</code> <code>tlvs</code>, or <code>null</code> if not present
     */
    Tlvs getTlvs();
    
    /**
     * @return <code>java.lang.Short</code> <code>priority</code>, or <code>null</code> if not present
     */
    java.lang.Short getPriority();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId</code> <code>requestId</code>, or <code>null</code> if not present
     */
    RequestId getRequestId();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>reoptimization</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isReoptimization();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>biDirectional</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isBiDirectional();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>loose</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isLoose();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>pathKey</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isPathKey();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>fragmentation</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isFragmentation();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>p2mp</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isP2mp();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>eroCompression</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isEroCompression();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>supplyOf</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isSupplyOf();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>order</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isOrder();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>makeBeforeBreak</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isMakeBeforeBreak();

}

