package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.SvecObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container svec {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     leaf link-diverse {
 *         type link-diverse;
 *     }
 *     leaf node-diverse {
 *         type node-diverse;
 *     }
 *     leaf srlg-diverse {
 *         type srlg-diverse;
 *     }
 *     leaf-list requests-ids {
 *         type request-id;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/svec-object/svec</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.SvecBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.SvecBuilder
 *
 */
public interface Svec
    extends
    ChildOf<SvecObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.Svec>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "svec").intern();

    /**
     * @return <code>java.lang.Boolean</code> <code>linkDiverse</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isLinkDiverse();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>nodeDiverse</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isNodeDiverse();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>srlgDiverse</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isSrlgDiverse();
    
    /**
     * @return <code>java.util.List</code> <code>requestsIds</code>, or <code>null</code> if not present
     */
    List<RequestId> getRequestsIds();

}

