package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.rev130409;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceType;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Service representing a PCEP dispatcher service. The servicecan create both PCEP 
 * client sessions and PCEP servers.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>odl-pcep-api-cfg</b>
 * <pre>
 * identity pcep-dispatcher {
 *     base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:controller:config?revision=2013-04-05)service-type, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:controller:config?revision=2013-04-05)service-type]}}";
 *     description
 *         "Service representing a PCEP dispatcher service. The service
 *         can create both PCEP client sessions and PCEP servers.";
 *     status CURRENT;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>odl-pcep-api-cfg/pcep-dispatcher</i>
 *
 */
public abstract class PcepDispatcher extends ServiceType
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep",
        "2013-04-09", "pcep-dispatcher").intern();


    public PcepDispatcher() {
    
    
    }
    






}

