package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * PCEP Error-type/value.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * grouping error {
 *     leaf error-type {
 *         type error-type;
 *     }
 *     leaf error-value {
 *         type error-value;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-session-stats/error</i>
 *
 */
public interface Error
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:stats",
        "2014-10-06", "error").intern();

    /**
     * @return <code>java.lang.Short</code> <code>errorType</code>, or <code>null</code> if not present
     */
    java.lang.Short getErrorType();
    
    /**
     * @return <code>java.lang.Short</code> <code>errorValue</code>, or <code>null</code> if not present
     */
    java.lang.Short getErrorValue();

}

