package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.LocalPref;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.PeerPref;

/**
 * PCEP session statistics.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * grouping pcep-session-state {
 *     container messages {
 *         leaf received-msg-count {
 *             type uint32;
 *         }
 *         leaf sent-msg-count {
 *             type uint32;
 *         }
 *         leaf last-sent-msg-timestamp {
 *             type uint32;
 *         }
 *         leaf unknown-msg-received {
 *             type uint16;
 *         }
 *         container error-messages {
 *             leaf received-error-msg-count {
 *                 type uint32;
 *             }
 *             leaf sent-error-msg-count {
 *                 type uint32;
 *             }
 *             container last-received-error {
 *                 leaf error-type {
 *                     type error-type;
 *                 }
 *                 leaf error-value {
 *                     type error-value;
 *                 }
 *                 uses error;
 *             }
 *             container last-sent-error {
 *                 leaf error-type {
 *                     type error-type;
 *                 }
 *                 leaf error-value {
 *                     type error-value;
 *                 }
 *                 uses error;
 *             }
 *         }
 *     }
 *     container local-pref {
 *         leaf keepalive {
 *             type keepalive;
 *         }
 *         leaf deadtimer {
 *             type deadtimer;
 *         }
 *         leaf ip-address {
 *             type ip-address;
 *         }
 *         leaf session-id {
 *             type session-id;
 *         }
 *         uses preferences;
 *     }
 *     container peer-pref {
 *         leaf keepalive {
 *             type keepalive;
 *         }
 *         leaf deadtimer {
 *             type deadtimer;
 *         }
 *         leaf ip-address {
 *             type ip-address;
 *         }
 *         leaf session-id {
 *             type session-id;
 *         }
 *         uses preferences;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-session-stats/pcep-session-state</i>
 *
 */
public interface PcepSessionState
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:stats",
        "2014-10-06", "pcep-session-state").intern();

    /**
     * The statistics of PCEP received/sent messages from the PCE point of view.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages</code> <code>messages</code>, or <code>null</code> if not present
     */
    Messages getMessages();
    
    /**
     * The local (PCE) preferences.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.LocalPref</code> <code>localPref</code>, or <code>null</code> if not present
     */
    LocalPref getLocalPref();
    
    /**
     * The remote peer (PCC) preferences.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.PeerPref</code> <code>peerPref</code>, or <code>null</code> if not present
     */
    PeerPref getPeerPref();

}

