package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * grouping preferences {
 *     leaf keepalive {
 *         type keepalive;
 *     }
 *     leaf deadtimer {
 *         type deadtimer;
 *     }
 *     leaf ip-address {
 *         type ip-address;
 *     }
 *     leaf session-id {
 *         type session-id;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-session-stats/preferences</i>
 *
 */
public interface Preferences
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:stats",
        "2014-10-06", "preferences").intern();

    /**
     * Advertised keep-alive value.
     *
     *
     *
     * @return <code>java.lang.Short</code> <code>keepalive</code>, or <code>null</code> if not present
     */
    java.lang.Short getKeepalive();
    
    /**
     * Advertised deadtimer value.
     *
     *
     *
     * @return <code>java.lang.Short</code> <code>deadtimer</code>, or <code>null</code> if not present
     */
    java.lang.Short getDeadtimer();
    
    /**
     * Peer's IP address.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>ipAddress</code>, or <code>null</code> if not present
     */
    java.lang.String getIpAddress();
    
    /**
     * Peer's session identifier.
     *
     *
     *
     * @return <code>java.lang.Integer</code> <code>sessionId</code>, or <code>null</code> if not present
     */
    java.lang.Integer getSessionId();

}

