package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.error.messages.LastReceivedError;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.error.messages.LastSentError;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * The message statistics of received/sent PCErr messages.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * container error-messages {
 *     leaf received-error-msg-count {
 *         type uint32;
 *     }
 *     leaf sent-error-msg-count {
 *         type uint32;
 *     }
 *     container last-received-error {
 *         leaf error-type {
 *             type error-type;
 *         }
 *         leaf error-value {
 *             type error-value;
 *         }
 *         uses error;
 *     }
 *     container last-sent-error {
 *         leaf error-type {
 *             type error-type;
 *         }
 *         leaf error-value {
 *             type error-value;
 *         }
 *         uses error;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-session-stats/pcep-session-state/messages/error-messages</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessagesBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessagesBuilder
 *
 */
public interface ErrorMessages
    extends
    ChildOf<Messages>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:stats",
        "2014-10-06", "error-messages").intern();

    /**
     * Total number of received PCErr messages.
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>receivedErrorMsgCount</code>, or <code>null</code> if not present
     */
    java.lang.Long getReceivedErrorMsgCount();
    
    /**
     * Total number of sent PCErr messages.
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>sentErrorMsgCount</code>, or <code>null</code> if not present
     */
    java.lang.Long getSentErrorMsgCount();
    
    /**
     * Type/value tuple of last received error.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.error.messages.LastReceivedError</code> <code>lastReceivedError</code>, or <code>null</code> if not present
     */
    LastReceivedError getLastReceivedError();
    
    /**
     * Type/value tuple of last sent error.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.error.messages.LastSentError</code> <code>lastSentError</code>, or <code>null</code> if not present
     */
    LastSentError getLastSentError();

}

