package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.error.messages;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.ErrorMessages;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.Error;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * Type/value tuple of last received error.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * container last-received-error {
 *     leaf error-type {
 *         type error-type;
 *     }
 *     leaf error-value {
 *         type error-value;
 *     }
 *     uses error;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-session-stats/pcep-session-state/messages/error-messages/last-received-error</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.error.messages.LastReceivedErrorBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.error.messages.LastReceivedErrorBuilder
 *
 */
public interface LastReceivedError
    extends
    ChildOf<ErrorMessages>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stats.rev141006.pcep.session.state.messages.error.messages.LastReceivedError>,
    Error
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:controller:pcep:stats",
        "2014-10-06", "last-received-error").intern();


}

