package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenMessage;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-message</b>
 * <pre>
 * notification open {
 *     container open-message {
 *         leaf version {
 *             type version;
 *         }
 *         container open {
 *             container tlvs {
 *                 container of-list {
 *                     leaf-list codes {
 *                         type of-id;
 *                     }
 *                     uses tlv;
 *                 }
 *                 list vendor-information-tlv {
 *                     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses of-list-tlv;
 *                 uses vendor-information-tlvs;
 *             }
 *             leaf version {
 *                 type version;
 *             }
 *             leaf keepalive {
 *                 type uint8;
 *             }
 *             leaf dead-timer {
 *                 type uint8;
 *             }
 *             leaf session-id {
 *                 type uint8;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses message-header;
 *         uses open-object;
 *     }
 *     uses open-message;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-message/open</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.OpenBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.OpenBuilder
 *
 */
public interface Open
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Open>,
    OpenMessage,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:message",
        "2013-10-07", "open").intern();


}

