package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for receiving the following YANG notifications defined in module <b>pcep-message</b>
 * <pre>
 * notification pcerr {
 *     container pcerr-message {
 *         list errors {
 *             container error-object {
 *                 container tlvs {
 *                     container req-missing {
 *                         leaf request-id {
 *                             type request-id;
 *                         }
 *                         uses tlv;
 *                     }
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                     uses req-missing-tlv;
 *                 }
 *                 leaf type {
 *                     type uint8;
 *                 }
 *                 leaf value {
 *                     type uint8;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses pcep-error-object;
 *         }
 *         choice error-type {
 *             case request-case {
 *                 container request {
 *                     list rps {
 *                         container rp {
 *                             container tlvs {
 *                                 container order {
 *                                     leaf delete {
 *                                         type uint32;
 *                                     }
 *                                     leaf setup {
 *                                         type uint32;
 *                                     }
 *                                     uses tlv;
 *                                 }
 *                                 container path-setup-type {
 *                                     leaf pst {
 *                                         type pst;
 *                                     }
 *                                     uses tlv;
 *                                 }
 *                                 list vendor-information-tlv {
 *                                     leaf enterprise-number {
 *                                         type enterprise-number;
 *                                     }
 *                                     choice enterprise-specific-information {
 *                                     }
 *                                     uses vendor-information;
 *                                     uses tlv;
 *                                 }
 *                                 uses vendor-information-tlvs;
 *                                 uses order-tlv;
 *                                 uses path-setup-type-tlv;
 *                             }
 *                             leaf priority {
 *                                 type uint8;
 *                             }
 *                             leaf request-id {
 *                                 type request-id;
 *                             }
 *                             leaf reoptimization {
 *                                 type reoptimization;
 *                             }
 *                             leaf bi-directional {
 *                                 type bi-directional;
 *                             }
 *                             leaf loose {
 *                                 type loose;
 *                             }
 *                             leaf path-key {
 *                                 type path-key;
 *                             }
 *                             leaf fragmentation {
 *                                 type fragmentation;
 *                             }
 *                             leaf p2mp {
 *                                 type p2mp;
 *                             }
 *                             leaf ero-compression {
 *                                 type ero-compression;
 *                             }
 *                             leaf supply-of {
 *                                 type supply-of;
 *                             }
 *                             leaf order {
 *                                 type order;
 *                             }
 *                             leaf make-before-break {
 *                                 type make-before-break;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses rp-object;
 *                     }
 *                 }
 *             }
 *             case session-case {
 *                 container session {
 *                     container open {
 *                         container tlvs {
 *                             container of-list {
 *                                 leaf-list codes {
 *                                     type of-id;
 *                                 }
 *                                 uses tlv;
 *                             }
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses of-list-tlv;
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf version {
 *                             type version;
 *                         }
 *                         leaf keepalive {
 *                             type uint8;
 *                         }
 *                         leaf dead-timer {
 *                             type uint8;
 *                         }
 *                         leaf session-id {
 *                             type uint8;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     uses open-object;
 *                 }
 *             }
 *         }
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 *     uses pcerr-message;
 * }
 * notification keepalive {
 *     container keepalive-message {
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 *     uses keepalive-message;
 * }
 * notification close {
 *     container c-close-message {
 *         leaf version {
 *             type version;
 *         }
 *         container c-close {
 *             leaf reason {
 *                 type uint8;
 *             }
 *             container tlvs {
 *                 list vendor-information-tlv {
 *                     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses message-header;
 *         uses close-object;
 *     }
 *     uses close-message;
 * }
 * notification pcntf {
 *     container pcntf-message {
 *         list notifications {
 *             list rps {
 *                 container rp {
 *                     container tlvs {
 *                         container order {
 *                             leaf delete {
 *                                 type uint32;
 *                             }
 *                             leaf setup {
 *                                 type uint32;
 *                             }
 *                             uses tlv;
 *                         }
 *                         container path-setup-type {
 *                             leaf pst {
 *                                 type pst;
 *                             }
 *                             uses tlv;
 *                         }
 *                         list vendor-information-tlv {
 *                             leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         uses vendor-information-tlvs;
 *                         uses order-tlv;
 *                         uses path-setup-type-tlv;
 *                     }
 *                     leaf priority {
 *                         type uint8;
 *                     }
 *                     leaf request-id {
 *                         type request-id;
 *                     }
 *                     leaf reoptimization {
 *                         type reoptimization;
 *                     }
 *                     leaf bi-directional {
 *                         type bi-directional;
 *                     }
 *                     leaf loose {
 *                         type loose;
 *                     }
 *                     leaf path-key {
 *                         type path-key;
 *                     }
 *                     leaf fragmentation {
 *                         type fragmentation;
 *                     }
 *                     leaf p2mp {
 *                         type p2mp;
 *                     }
 *                     leaf ero-compression {
 *                         type ero-compression;
 *                     }
 *                     leaf supply-of {
 *                         type supply-of;
 *                     }
 *                     leaf order {
 *                         type order;
 *                     }
 *                     leaf make-before-break {
 *                         type make-before-break;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses rp-object;
 *             }
 *             list notifications {
 *                 container c-notification {
 *                     container tlvs {
 *                         container overload-duration {
 *                             leaf duration {
 *                                 type duration;
 *                             }
 *                             uses tlv;
 *                         }
 *                         list vendor-information-tlv {
 *                             leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         uses vendor-information-tlvs;
 *                         uses overload-duration-tlv;
 *                     }
 *                     leaf type {
 *                         type uint8;
 *                     }
 *                     leaf value {
 *                         type uint8;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses notification-object;
 *             }
 *         }
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 *     uses pcntf-message;
 * }
 * notification pcreq {
 *     container pcreq-message {
 *         list requests {
 *             container path-key-expansion {
 *                 container path-key {
 *                     list path-keys {
 *                         leaf loose {
 *                             type loose;
 *                         }
 *                         leaf pce-id {
 *                             type pce-id;
 *                         }
 *                         leaf path-key {
 *                             type path-key;
 *                         }
 *                         uses path-key-subobject;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses path-key-object;
 *             }
 *             container segment-computation {
 *                 container p2p {
 *                     container reported-route {
 *                         container reoptimization-bandwidth {
 *                             leaf bandwidth {
 *                                 type bandwidth;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                             uses bandwidth;
 *                         }
 *                         container rro {
 *                             list subobject {
 *                                 leaf protection-available {
 *                                     type protection-available;
 *                                 }
 *                                 leaf protection-in-use {
 *                                     type protection-in-use;
 *                                 }
 *                                 choice subobject-type {
 *                                     case ip-prefix-case {
 *                                         container ip-prefix {
 *                                             leaf ip-prefix {
 *                                                 type ip-prefix;
 *                                             }
 *                                             uses ip-prefix-subobject;
 *                                         }
 *                                     }
 *                                     case label-case {
 *                                         container label {
 *                                             leaf global {
 *                                                 type global;
 *                                             }
 *                                             leaf uni-directional {
 *                                                 type boolean;
 *                                             }
 *                                             choice label-type {
 *                                                 case generalized-label-case {
 *                                                     container generalized-label {
 *                                                         leaf generalized-label {
 *                                                             type binary;
 *                                                         }
 *                                                         uses generalized-label;
 *                                                     }
 *                                                 }
 *                                                 case type1-label-case {
 *                                                     container type1-label {
 *                                                         leaf type1-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses type1-label;
 *                                                     }
 *                                                 }
 *                                                 case waveband-switching-label-case {
 *                                                     container waveband-switching-label {
 *                                                         leaf end-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf start-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf waveband-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses waveband-switching-label;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses label-subobject;
 *                                         }
 *                                     }
 *                                     case path-key-case {
 *                                         container path-key {
 *                                             leaf pce-id {
 *                                                 type pce-id;
 *                                             }
 *                                             leaf path-key {
 *                                                 type path-key;
 *                                             }
 *                                             uses path-key-subobject;
 *                                         }
 *                                     }
 *                                     case unnumbered-case {
 *                                         container unnumbered {
 *                                             leaf router-id {
 *                                                 type uint32;
 *                                             }
 *                                             leaf interface-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses unnumbered-subobject;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses record-route-subobjects;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses reoptimization-bandwidth-object;
 *                         uses reported-route-object;
 *                     }
 *                     container endpoints-obj {
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         choice address-family {
 *                             case ipv4-case {
 *                                 container ipv4 {
 *                                     leaf source-ipv4-address {
 *                                         type ipv4-address;
 *                                     }
 *                                     leaf destination-ipv4-address {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv6-case {
 *                                 container ipv6 {
 *                                     leaf source-ipv6-address {
 *                                         type ipv6-address;
 *                                     }
 *                                     leaf destination-ipv6-address {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses object;
 *                         uses endpoints;
 *                     }
 *                     list vendor-information-object {
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses object;
 *                     }
 *                     container load-balancing {
 *                         leaf max-lsp {
 *                             type uint8;
 *                         }
 *                         leaf min-bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     list metrics {
 *                         container metric {
 *                             leaf metric-type {
 *                                 type uint8;
 *                             }
 *                             leaf bound {
 *                                 type bound;
 *                             }
 *                             leaf computed {
 *                                 type computed;
 *                             }
 *                             leaf value {
 *                                 type float32;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses metric-object;
 *                     }
 *                     container bandwidth {
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses bandwidth;
 *                     }
 *                     container reoptimization-bandwidth {
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses bandwidth;
 *                     }
 *                     container class-type {
 *                         leaf class-type {
 *                             type class-type;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container lspa {
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         leaf local-protection-desired {
 *                             type local-protection-desired;
 *                         }
 *                         leaf label-recording-desired {
 *                             type label-recording-desired;
 *                         }
 *                         leaf se-style-desired {
 *                             type se-style-desired;
 *                         }
 *                         leaf session-name {
 *                             type string;
 *                         }
 *                         leaf hold-priority {
 *                             type hold-priority;
 *                         }
 *                         leaf setup-priority {
 *                             type setup-priority;
 *                         }
 *                         leaf include-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf exclude-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf include-all {
 *                             type attribute-filter;
 *                         }
 *                         uses tunnel-attributes;
 *                         uses object;
 *                     }
 *                     container of {
 *                         leaf code {
 *                             type of-id;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container rro {
 *                         list subobject {
 *                             leaf protection-available {
 *                                 type protection-available;
 *                             }
 *                             leaf protection-in-use {
 *                                 type protection-in-use;
 *                             }
 *                             choice subobject-type {
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf global {
 *                                             type global;
 *                                         }
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses record-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container xro {
 *                         leaf flags {
 *                             type bits;
 *                         }
 *                         list subobject {
 *                             leaf mandatory {
 *                                 type mandatory;
 *                             }
 *                             leaf attribute {
 *                                 type enumeration;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses exclude-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container iro {
 *                         list subobject {
 *                             leaf loose {
 *                                 type boolean;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case exrs-case {
 *                                     container exrs {
 *                                         list exrs {
 *                                             leaf mandatory {
 *                                                 type mandatory;
 *                                             }
 *                                             leaf attribute {
 *                                                 type enumeration;
 *                                             }
 *                                             choice subobject-type {
 *                                                 case as-number-case {
 *                                                     container as-number {
 *                                                         leaf as-number {
 *                                                             type as-number;
 *                                                         }
 *                                                         uses as-number-subobject;
 *                                                     }
 *                                                 }
 *                                                 case ip-prefix-case {
 *                                                     container ip-prefix {
 *                                                         leaf ip-prefix {
 *                                                             type ip-prefix;
 *                                                         }
 *                                                         uses ip-prefix-subobject;
 *                                                     }
 *                                                 }
 *                                                 case label-case {
 *                                                     container label {
 *                                                         leaf uni-directional {
 *                                                             type boolean;
 *                                                         }
 *                                                         choice label-type {
 *                                                             case generalized-label-case {
 *                                                                 container generalized-label {
 *                                                                     leaf generalized-label {
 *                                                                         type binary;
 *                                                                     }
 *                                                                     uses generalized-label;
 *                                                                 }
 *                                                             }
 *                                                             case type1-label-case {
 *                                                                 container type1-label {
 *                                                                     leaf type1-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses type1-label;
 *                                                                 }
 *                                                             }
 *                                                             case waveband-switching-label-case {
 *                                                                 container waveband-switching-label {
 *                                                                     leaf end-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf start-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf waveband-id {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses waveband-switching-label;
 *                                                                 }
 *                                                             }
 *                                                         }
 *                                                         uses label-subobject;
 *                                                     }
 *                                                 }
 *                                                 case srlg-case {
 *                                                     container srlg {
 *                                                         leaf srlg-id {
 *                                                             type srlg-id;
 *                                                         }
 *                                                         uses srlg-subobject;
 *                                                     }
 *                                                 }
 *                                                 case unnumbered-case {
 *                                                     container unnumbered {
 *                                                         leaf router-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf interface-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses unnumbered-subobject;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses exclude-route-subobjects;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses explicit-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     uses endpoints-object;
 *                     uses vendor-information-objects;
 *                     uses load-balancing-object;
 *                     uses lsp-attributes;
 *                 }
 *             }
 *             list vendor-information-object {
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses object;
 *             }
 *             container rp {
 *                 container tlvs {
 *                     container order {
 *                         leaf delete {
 *                             type uint32;
 *                         }
 *                         leaf setup {
 *                             type uint32;
 *                         }
 *                         uses tlv;
 *                     }
 *                     container path-setup-type {
 *                         leaf pst {
 *                             type pst;
 *                         }
 *                         uses tlv;
 *                     }
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                     uses order-tlv;
 *                     uses path-setup-type-tlv;
 *                 }
 *                 leaf priority {
 *                     type uint8;
 *                 }
 *                 leaf request-id {
 *                     type request-id;
 *                 }
 *                 leaf reoptimization {
 *                     type reoptimization;
 *                 }
 *                 leaf bi-directional {
 *                     type bi-directional;
 *                 }
 *                 leaf loose {
 *                     type loose;
 *                 }
 *                 leaf path-key {
 *                     type path-key;
 *                 }
 *                 leaf fragmentation {
 *                     type fragmentation;
 *                 }
 *                 leaf p2mp {
 *                     type p2mp;
 *                 }
 *                 leaf ero-compression {
 *                     type ero-compression;
 *                 }
 *                 leaf supply-of {
 *                     type supply-of;
 *                 }
 *                 leaf order {
 *                     type order;
 *                 }
 *                 leaf make-before-break {
 *                     type make-before-break;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses rp-object;
 *             uses vendor-information-objects;
 *         }
 *         list svec {
 *             list metric {
 *                 container metric {
 *                     leaf metric-type {
 *                         type uint8;
 *                     }
 *                     leaf bound {
 *                         type bound;
 *                     }
 *                     leaf computed {
 *                         type computed;
 *                     }
 *                     leaf value {
 *                         type float32;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses metric-object;
 *             }
 *             container svec {
 *                 leaf link-diverse {
 *                     type link-diverse;
 *                 }
 *                 leaf node-diverse {
 *                     type node-diverse;
 *                 }
 *                 leaf srlg-diverse {
 *                     type srlg-diverse;
 *                 }
 *                 leaf-list requests-ids {
 *                     type request-id;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             list vendor-information-object {
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses object;
 *             }
 *             container gc {
 *                 leaf max-hop {
 *                     type uint8;
 *                 }
 *                 leaf max-utilization {
 *                     type max-utilization;
 *                 }
 *                 leaf min-utilization {
 *                     type min-utilization;
 *                 }
 *                 leaf over-booking-factor {
 *                     type over-booking-factor;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container of {
 *                 leaf code {
 *                     type of-id;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container xro {
 *                 leaf flags {
 *                     type bits;
 *                 }
 *                 list subobject {
 *                     leaf mandatory {
 *                         type mandatory;
 *                     }
 *                     leaf attribute {
 *                         type enumeration;
 *                     }
 *                     choice subobject-type {
 *                         case as-number-case {
 *                             container as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                                 uses as-number-subobject;
 *                             }
 *                         }
 *                         case ip-prefix-case {
 *                             container ip-prefix {
 *                                 leaf ip-prefix {
 *                                     type ip-prefix;
 *                                 }
 *                                 uses ip-prefix-subobject;
 *                             }
 *                         }
 *                         case label-case {
 *                             container label {
 *                                 leaf uni-directional {
 *                                     type boolean;
 *                                 }
 *                                 choice label-type {
 *                                     case generalized-label-case {
 *                                         container generalized-label {
 *                                             leaf generalized-label {
 *                                                 type binary;
 *                                             }
 *                                             uses generalized-label;
 *                                         }
 *                                     }
 *                                     case type1-label-case {
 *                                         container type1-label {
 *                                             leaf type1-label {
 *                                                 type uint32;
 *                                             }
 *                                             uses type1-label;
 *                                         }
 *                                     }
 *                                     case waveband-switching-label-case {
 *                                         container waveband-switching-label {
 *                                             leaf end-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf start-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf waveband-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses waveband-switching-label;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses label-subobject;
 *                             }
 *                         }
 *                         case srlg-case {
 *                             container srlg {
 *                                 leaf srlg-id {
 *                                     type srlg-id;
 *                                 }
 *                                 uses srlg-subobject;
 *                             }
 *                         }
 *                         case unnumbered-case {
 *                             container unnumbered {
 *                                 leaf router-id {
 *                                     type uint32;
 *                                 }
 *                                 leaf interface-id {
 *                                     type uint32;
 *                                 }
 *                                 uses unnumbered-subobject;
 *                             }
 *                         }
 *                     }
 *                     uses exclude-route-subobjects;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses svec-object;
 *             uses exclude-route-object;
 *             uses gc-object;
 *             uses of-object;
 *             uses vendor-information-objects;
 *         }
 *         container monitoring-request {
 *             list pce-id-list {
 *                 container pce-id {
 *                     leaf ip-address {
 *                         type ip-address;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses pce-id-object;
 *             }
 *             container pcc-id-req {
 *                 leaf ip-address {
 *                     type ip-address;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container monitoring {
 *                 leaf flags {
 *                     type bits;
 *                 }
 *                 leaf monitoring-id {
 *                     type uint32;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses monitoring;
 *         }
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 *     uses pcreq-message;
 * }
 * notification pcrep {
 *     container pcrep-message {
 *         list replies {
 *             choice result {
 *                 case failure-case {
 *                     container no-path {
 *                         container tlvs {
 *                             container no-path-vector {
 *                                 leaf flags {
 *                                     type bits;
 *                                 }
 *                                 uses no-path-vector-tlv;
 *                             }
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf nature-of-issue {
 *                             type uint8;
 *                         }
 *                         leaf unsatisfied-constraints {
 *                             type unsatisfied-constraints;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses no-path-object;
 *                     }
 *                     list metrics {
 *                         container metric {
 *                             leaf metric-type {
 *                                 type uint8;
 *                             }
 *                             leaf bound {
 *                                 type bound;
 *                             }
 *                             leaf computed {
 *                                 type computed;
 *                             }
 *                             leaf value {
 *                                 type float32;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses metric-object;
 *                     }
 *                     container bandwidth {
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses bandwidth;
 *                     }
 *                     container reoptimization-bandwidth {
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses bandwidth;
 *                     }
 *                     container class-type {
 *                         leaf class-type {
 *                             type class-type;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container lspa {
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         leaf local-protection-desired {
 *                             type local-protection-desired;
 *                         }
 *                         leaf label-recording-desired {
 *                             type label-recording-desired;
 *                         }
 *                         leaf se-style-desired {
 *                             type se-style-desired;
 *                         }
 *                         leaf session-name {
 *                             type string;
 *                         }
 *                         leaf hold-priority {
 *                             type hold-priority;
 *                         }
 *                         leaf setup-priority {
 *                             type setup-priority;
 *                         }
 *                         leaf include-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf exclude-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf include-all {
 *                             type attribute-filter;
 *                         }
 *                         uses tunnel-attributes;
 *                         uses object;
 *                     }
 *                     container of {
 *                         leaf code {
 *                             type of-id;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container rro {
 *                         list subobject {
 *                             leaf protection-available {
 *                                 type protection-available;
 *                             }
 *                             leaf protection-in-use {
 *                                 type protection-in-use;
 *                             }
 *                             choice subobject-type {
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf global {
 *                                             type global;
 *                                         }
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses record-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container xro {
 *                         leaf flags {
 *                             type bits;
 *                         }
 *                         list subobject {
 *                             leaf mandatory {
 *                                 type mandatory;
 *                             }
 *                             leaf attribute {
 *                                 type enumeration;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses exclude-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container iro {
 *                         list subobject {
 *                             leaf loose {
 *                                 type boolean;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case exrs-case {
 *                                     container exrs {
 *                                         list exrs {
 *                                             leaf mandatory {
 *                                                 type mandatory;
 *                                             }
 *                                             leaf attribute {
 *                                                 type enumeration;
 *                                             }
 *                                             choice subobject-type {
 *                                                 case as-number-case {
 *                                                     container as-number {
 *                                                         leaf as-number {
 *                                                             type as-number;
 *                                                         }
 *                                                         uses as-number-subobject;
 *                                                     }
 *                                                 }
 *                                                 case ip-prefix-case {
 *                                                     container ip-prefix {
 *                                                         leaf ip-prefix {
 *                                                             type ip-prefix;
 *                                                         }
 *                                                         uses ip-prefix-subobject;
 *                                                     }
 *                                                 }
 *                                                 case label-case {
 *                                                     container label {
 *                                                         leaf uni-directional {
 *                                                             type boolean;
 *                                                         }
 *                                                         choice label-type {
 *                                                             case generalized-label-case {
 *                                                                 container generalized-label {
 *                                                                     leaf generalized-label {
 *                                                                         type binary;
 *                                                                     }
 *                                                                     uses generalized-label;
 *                                                                 }
 *                                                             }
 *                                                             case type1-label-case {
 *                                                                 container type1-label {
 *                                                                     leaf type1-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses type1-label;
 *                                                                 }
 *                                                             }
 *                                                             case waveband-switching-label-case {
 *                                                                 container waveband-switching-label {
 *                                                                     leaf end-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf start-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf waveband-id {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses waveband-switching-label;
 *                                                                 }
 *                                                             }
 *                                                         }
 *                                                         uses label-subobject;
 *                                                     }
 *                                                 }
 *                                                 case srlg-case {
 *                                                     container srlg {
 *                                                         leaf srlg-id {
 *                                                             type srlg-id;
 *                                                         }
 *                                                         uses srlg-subobject;
 *                                                     }
 *                                                 }
 *                                                 case unnumbered-case {
 *                                                     container unnumbered {
 *                                                         leaf router-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf interface-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses unnumbered-subobject;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses exclude-route-subobjects;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses explicit-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                 }
 *                 case success-case {
 *                     container success {
 *                         list paths {
 *                             container ero {
 *                                 list subobject {
 *                                     leaf loose {
 *                                         type boolean;
 *                                     }
 *                                     choice subobject-type {
 *                                         case as-number-case {
 *                                             container as-number {
 *                                                 leaf as-number {
 *                                                     type as-number;
 *                                                 }
 *                                                 uses as-number-subobject;
 *                                             }
 *                                         }
 *                                         case exrs-case {
 *                                             container exrs {
 *                                                 list exrs {
 *                                                     leaf mandatory {
 *                                                         type mandatory;
 *                                                     }
 *                                                     leaf attribute {
 *                                                         type enumeration;
 *                                                     }
 *                                                     choice subobject-type {
 *                                                         case as-number-case {
 *                                                             container as-number {
 *                                                                 leaf as-number {
 *                                                                     type as-number;
 *                                                                 }
 *                                                                 uses as-number-subobject;
 *                                                             }
 *                                                         }
 *                                                         case ip-prefix-case {
 *                                                             container ip-prefix {
 *                                                                 leaf ip-prefix {
 *                                                                     type ip-prefix;
 *                                                                 }
 *                                                                 uses ip-prefix-subobject;
 *                                                             }
 *                                                         }
 *                                                         case label-case {
 *                                                             container label {
 *                                                                 leaf uni-directional {
 *                                                                     type boolean;
 *                                                                 }
 *                                                                 choice label-type {
 *                                                                     case generalized-label-case {
 *                                                                         container generalized-label {
 *                                                                             leaf generalized-label {
 *                                                                                 type binary;
 *                                                                             }
 *                                                                             uses generalized-label;
 *                                                                         }
 *                                                                     }
 *                                                                     case type1-label-case {
 *                                                                         container type1-label {
 *                                                                             leaf type1-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             uses type1-label;
 *                                                                         }
 *                                                                     }
 *                                                                     case waveband-switching-label-case {
 *                                                                         container waveband-switching-label {
 *                                                                             leaf end-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             leaf start-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             leaf waveband-id {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             uses waveband-switching-label;
 *                                                                         }
 *                                                                     }
 *                                                                 }
 *                                                                 uses label-subobject;
 *                                                             }
 *                                                         }
 *                                                         case srlg-case {
 *                                                             container srlg {
 *                                                                 leaf srlg-id {
 *                                                                     type srlg-id;
 *                                                                 }
 *                                                                 uses srlg-subobject;
 *                                                             }
 *                                                         }
 *                                                         case unnumbered-case {
 *                                                             container unnumbered {
 *                                                                 leaf router-id {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 leaf interface-id {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 uses unnumbered-subobject;
 *                                                             }
 *                                                         }
 *                                                     }
 *                                                     uses exclude-route-subobjects;
 *                                                 }
 *                                             }
 *                                         }
 *                                         case ip-prefix-case {
 *                                             container ip-prefix {
 *                                                 leaf ip-prefix {
 *                                                     type ip-prefix;
 *                                                 }
 *                                                 uses ip-prefix-subobject;
 *                                             }
 *                                         }
 *                                         case label-case {
 *                                             container label {
 *                                                 leaf uni-directional {
 *                                                     type boolean;
 *                                                 }
 *                                                 choice label-type {
 *                                                     case generalized-label-case {
 *                                                         container generalized-label {
 *                                                             leaf generalized-label {
 *                                                                 type binary;
 *                                                             }
 *                                                             uses generalized-label;
 *                                                         }
 *                                                     }
 *                                                     case type1-label-case {
 *                                                         container type1-label {
 *                                                             leaf type1-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses type1-label;
 *                                                         }
 *                                                     }
 *                                                     case waveband-switching-label-case {
 *                                                         container waveband-switching-label {
 *                                                             leaf end-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf start-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf waveband-id {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses waveband-switching-label;
 *                                                         }
 *                                                     }
 *                                                 }
 *                                                 uses label-subobject;
 *                                             }
 *                                         }
 *                                         case path-key-case {
 *                                             container path-key {
 *                                                 leaf pce-id {
 *                                                     type pce-id;
 *                                                 }
 *                                                 leaf path-key {
 *                                                     type path-key;
 *                                                 }
 *                                                 uses path-key-subobject;
 *                                             }
 *                                         }
 *                                         case srlg-case {
 *                                             container srlg {
 *                                                 leaf srlg-id {
 *                                                     type srlg-id;
 *                                                 }
 *                                                 uses srlg-subobject;
 *                                             }
 *                                         }
 *                                         case unnumbered-case {
 *                                             container unnumbered {
 *                                                 leaf router-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf interface-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses unnumbered-subobject;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses explicit-route-subobjects;
 *                                 }
 *                                 leaf processing-rule {
 *                                     type processing-rule;
 *                                 }
 *                                 leaf ignore {
 *                                     type ignore;
 *                                 }
 *                                 uses object;
 *                             }
 *                             list metrics {
 *                                 container metric {
 *                                     leaf metric-type {
 *                                         type uint8;
 *                                     }
 *                                     leaf bound {
 *                                         type bound;
 *                                     }
 *                                     leaf computed {
 *                                         type computed;
 *                                     }
 *                                     leaf value {
 *                                         type float32;
 *                                     }
 *                                     leaf processing-rule {
 *                                         type processing-rule;
 *                                     }
 *                                     leaf ignore {
 *                                         type ignore;
 *                                     }
 *                                     uses object;
 *                                 }
 *                                 uses metric-object;
 *                             }
 *                             container bandwidth {
 *                                 leaf bandwidth {
 *                                     type bandwidth;
 *                                 }
 *                                 leaf processing-rule {
 *                                     type processing-rule;
 *                                 }
 *                                 leaf ignore {
 *                                     type ignore;
 *                                 }
 *                                 uses object;
 *                                 uses bandwidth;
 *                             }
 *                             container reoptimization-bandwidth {
 *                                 leaf bandwidth {
 *                                     type bandwidth;
 *                                 }
 *                                 leaf processing-rule {
 *                                     type processing-rule;
 *                                 }
 *                                 leaf ignore {
 *                                     type ignore;
 *                                 }
 *                                 uses object;
 *                                 uses bandwidth;
 *                             }
 *                             container class-type {
 *                                 leaf class-type {
 *                                     type class-type;
 *                                 }
 *                                 leaf processing-rule {
 *                                     type processing-rule;
 *                                 }
 *                                 leaf ignore {
 *                                     type ignore;
 *                                 }
 *                                 uses object;
 *                             }
 *                             container lspa {
 *                                 container tlvs {
 *                                     list vendor-information-tlv {
 *                                         leaf enterprise-number {
 *                                             type enterprise-number;
 *                                         }
 *                                         choice enterprise-specific-information {
 *                                         }
 *                                         uses vendor-information;
 *                                         uses tlv;
 *                                     }
 *                                     uses vendor-information-tlvs;
 *                                 }
 *                                 leaf processing-rule {
 *                                     type processing-rule;
 *                                 }
 *                                 leaf ignore {
 *                                     type ignore;
 *                                 }
 *                                 leaf local-protection-desired {
 *                                     type local-protection-desired;
 *                                 }
 *                                 leaf label-recording-desired {
 *                                     type label-recording-desired;
 *                                 }
 *                                 leaf se-style-desired {
 *                                     type se-style-desired;
 *                                 }
 *                                 leaf session-name {
 *                                     type string;
 *                                 }
 *                                 leaf hold-priority {
 *                                     type hold-priority;
 *                                 }
 *                                 leaf setup-priority {
 *                                     type setup-priority;
 *                                 }
 *                                 leaf include-any {
 *                                     type attribute-filter;
 *                                 }
 *                                 leaf exclude-any {
 *                                     type attribute-filter;
 *                                 }
 *                                 leaf include-all {
 *                                     type attribute-filter;
 *                                 }
 *                                 uses tunnel-attributes;
 *                                 uses object;
 *                             }
 *                             container of {
 *                                 leaf code {
 *                                     type of-id;
 *                                 }
 *                                 container tlvs {
 *                                     list vendor-information-tlv {
 *                                         leaf enterprise-number {
 *                                             type enterprise-number;
 *                                         }
 *                                         choice enterprise-specific-information {
 *                                         }
 *                                         uses vendor-information;
 *                                         uses tlv;
 *                                     }
 *                                     uses vendor-information-tlvs;
 *                                 }
 *                                 leaf processing-rule {
 *                                     type processing-rule;
 *                                 }
 *                                 leaf ignore {
 *                                     type ignore;
 *                                 }
 *                                 uses object;
 *                             }
 *                             container rro {
 *                                 list subobject {
 *                                     leaf protection-available {
 *                                         type protection-available;
 *                                     }
 *                                     leaf protection-in-use {
 *                                         type protection-in-use;
 *                                     }
 *                                     choice subobject-type {
 *                                         case ip-prefix-case {
 *                                             container ip-prefix {
 *                                                 leaf ip-prefix {
 *                                                     type ip-prefix;
 *                                                 }
 *                                                 uses ip-prefix-subobject;
 *                                             }
 *                                         }
 *                                         case label-case {
 *                                             container label {
 *                                                 leaf global {
 *                                                     type global;
 *                                                 }
 *                                                 leaf uni-directional {
 *                                                     type boolean;
 *                                                 }
 *                                                 choice label-type {
 *                                                     case generalized-label-case {
 *                                                         container generalized-label {
 *                                                             leaf generalized-label {
 *                                                                 type binary;
 *                                                             }
 *                                                             uses generalized-label;
 *                                                         }
 *                                                     }
 *                                                     case type1-label-case {
 *                                                         container type1-label {
 *                                                             leaf type1-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses type1-label;
 *                                                         }
 *                                                     }
 *                                                     case waveband-switching-label-case {
 *                                                         container waveband-switching-label {
 *                                                             leaf end-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf start-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf waveband-id {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses waveband-switching-label;
 *                                                         }
 *                                                     }
 *                                                 }
 *                                                 uses label-subobject;
 *                                             }
 *                                         }
 *                                         case path-key-case {
 *                                             container path-key {
 *                                                 leaf pce-id {
 *                                                     type pce-id;
 *                                                 }
 *                                                 leaf path-key {
 *                                                     type path-key;
 *                                                 }
 *                                                 uses path-key-subobject;
 *                                             }
 *                                         }
 *                                         case unnumbered-case {
 *                                             container unnumbered {
 *                                                 leaf router-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf interface-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses unnumbered-subobject;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses record-route-subobjects;
 *                                 }
 *                                 leaf processing-rule {
 *                                     type processing-rule;
 *                                 }
 *                                 leaf ignore {
 *                                     type ignore;
 *                                 }
 *                                 uses object;
 *                             }
 *                             container xro {
 *                                 leaf flags {
 *                                     type bits;
 *                                 }
 *                                 list subobject {
 *                                     leaf mandatory {
 *                                         type mandatory;
 *                                     }
 *                                     leaf attribute {
 *                                         type enumeration;
 *                                     }
 *                                     choice subobject-type {
 *                                         case as-number-case {
 *                                             container as-number {
 *                                                 leaf as-number {
 *                                                     type as-number;
 *                                                 }
 *                                                 uses as-number-subobject;
 *                                             }
 *                                         }
 *                                         case ip-prefix-case {
 *                                             container ip-prefix {
 *                                                 leaf ip-prefix {
 *                                                     type ip-prefix;
 *                                                 }
 *                                                 uses ip-prefix-subobject;
 *                                             }
 *                                         }
 *                                         case label-case {
 *                                             container label {
 *                                                 leaf uni-directional {
 *                                                     type boolean;
 *                                                 }
 *                                                 choice label-type {
 *                                                     case generalized-label-case {
 *                                                         container generalized-label {
 *                                                             leaf generalized-label {
 *                                                                 type binary;
 *                                                             }
 *                                                             uses generalized-label;
 *                                                         }
 *                                                     }
 *                                                     case type1-label-case {
 *                                                         container type1-label {
 *                                                             leaf type1-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses type1-label;
 *                                                         }
 *                                                     }
 *                                                     case waveband-switching-label-case {
 *                                                         container waveband-switching-label {
 *                                                             leaf end-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf start-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf waveband-id {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses waveband-switching-label;
 *                                                         }
 *                                                     }
 *                                                 }
 *                                                 uses label-subobject;
 *                                             }
 *                                         }
 *                                         case srlg-case {
 *                                             container srlg {
 *                                                 leaf srlg-id {
 *                                                     type srlg-id;
 *                                                 }
 *                                                 uses srlg-subobject;
 *                                             }
 *                                         }
 *                                         case unnumbered-case {
 *                                             container unnumbered {
 *                                                 leaf router-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf interface-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses unnumbered-subobject;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses exclude-route-subobjects;
 *                                 }
 *                                 leaf processing-rule {
 *                                     type processing-rule;
 *                                 }
 *                                 leaf ignore {
 *                                     type ignore;
 *                                 }
 *                                 uses object;
 *                             }
 *                             container iro {
 *                                 list subobject {
 *                                     leaf loose {
 *                                         type boolean;
 *                                     }
 *                                     choice subobject-type {
 *                                         case as-number-case {
 *                                             container as-number {
 *                                                 leaf as-number {
 *                                                     type as-number;
 *                                                 }
 *                                                 uses as-number-subobject;
 *                                             }
 *                                         }
 *                                         case exrs-case {
 *                                             container exrs {
 *                                                 list exrs {
 *                                                     leaf mandatory {
 *                                                         type mandatory;
 *                                                     }
 *                                                     leaf attribute {
 *                                                         type enumeration;
 *                                                     }
 *                                                     choice subobject-type {
 *                                                         case as-number-case {
 *                                                             container as-number {
 *                                                                 leaf as-number {
 *                                                                     type as-number;
 *                                                                 }
 *                                                                 uses as-number-subobject;
 *                                                             }
 *                                                         }
 *                                                         case ip-prefix-case {
 *                                                             container ip-prefix {
 *                                                                 leaf ip-prefix {
 *                                                                     type ip-prefix;
 *                                                                 }
 *                                                                 uses ip-prefix-subobject;
 *                                                             }
 *                                                         }
 *                                                         case label-case {
 *                                                             container label {
 *                                                                 leaf uni-directional {
 *                                                                     type boolean;
 *                                                                 }
 *                                                                 choice label-type {
 *                                                                     case generalized-label-case {
 *                                                                         container generalized-label {
 *                                                                             leaf generalized-label {
 *                                                                                 type binary;
 *                                                                             }
 *                                                                             uses generalized-label;
 *                                                                         }
 *                                                                     }
 *                                                                     case type1-label-case {
 *                                                                         container type1-label {
 *                                                                             leaf type1-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             uses type1-label;
 *                                                                         }
 *                                                                     }
 *                                                                     case waveband-switching-label-case {
 *                                                                         container waveband-switching-label {
 *                                                                             leaf end-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             leaf start-label {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             leaf waveband-id {
 *                                                                                 type uint32;
 *                                                                             }
 *                                                                             uses waveband-switching-label;
 *                                                                         }
 *                                                                     }
 *                                                                 }
 *                                                                 uses label-subobject;
 *                                                             }
 *                                                         }
 *                                                         case srlg-case {
 *                                                             container srlg {
 *                                                                 leaf srlg-id {
 *                                                                     type srlg-id;
 *                                                                 }
 *                                                                 uses srlg-subobject;
 *                                                             }
 *                                                         }
 *                                                         case unnumbered-case {
 *                                                             container unnumbered {
 *                                                                 leaf router-id {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 leaf interface-id {
 *                                                                     type uint32;
 *                                                                 }
 *                                                                 uses unnumbered-subobject;
 *                                                             }
 *                                                         }
 *                                                     }
 *                                                     uses exclude-route-subobjects;
 *                                                 }
 *                                             }
 *                                         }
 *                                         case ip-prefix-case {
 *                                             container ip-prefix {
 *                                                 leaf ip-prefix {
 *                                                     type ip-prefix;
 *                                                 }
 *                                                 uses ip-prefix-subobject;
 *                                             }
 *                                         }
 *                                         case label-case {
 *                                             container label {
 *                                                 leaf uni-directional {
 *                                                     type boolean;
 *                                                 }
 *                                                 choice label-type {
 *                                                     case generalized-label-case {
 *                                                         container generalized-label {
 *                                                             leaf generalized-label {
 *                                                                 type binary;
 *                                                             }
 *                                                             uses generalized-label;
 *                                                         }
 *                                                     }
 *                                                     case type1-label-case {
 *                                                         container type1-label {
 *                                                             leaf type1-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses type1-label;
 *                                                         }
 *                                                     }
 *                                                     case waveband-switching-label-case {
 *                                                         container waveband-switching-label {
 *                                                             leaf end-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf start-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf waveband-id {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses waveband-switching-label;
 *                                                         }
 *                                                     }
 *                                                 }
 *                                                 uses label-subobject;
 *                                             }
 *                                         }
 *                                         case path-key-case {
 *                                             container path-key {
 *                                                 leaf pce-id {
 *                                                     type pce-id;
 *                                                 }
 *                                                 leaf path-key {
 *                                                     type path-key;
 *                                                 }
 *                                                 uses path-key-subobject;
 *                                             }
 *                                         }
 *                                         case srlg-case {
 *                                             container srlg {
 *                                                 leaf srlg-id {
 *                                                     type srlg-id;
 *                                                 }
 *                                                 uses srlg-subobject;
 *                                             }
 *                                         }
 *                                         case unnumbered-case {
 *                                             container unnumbered {
 *                                                 leaf router-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf interface-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses unnumbered-subobject;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses explicit-route-subobjects;
 *                                 }
 *                                 leaf processing-rule {
 *                                     type processing-rule;
 *                                 }
 *                                 leaf ignore {
 *                                     type ignore;
 *                                 }
 *                                 uses object;
 *                             }
 *                             uses path-definition;
 *                         }
 *                         list vendor-information-object {
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses object;
 *                         }
 *                         uses vendor-information-objects;
 *                     }
 *                 }
 *             }
 *             list vendor-information-object {
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses object;
 *             }
 *             list metric-pce {
 *                 container pce-id {
 *                     leaf ip-address {
 *                         type ip-address;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 container overload {
 *                     leaf duration {
 *                         type uint16;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 container proc-time {
 *                     leaf estimated {
 *                         type boolean;
 *                     }
 *                     leaf current-proc-time {
 *                         type uint32;
 *                     }
 *                     leaf min-proc-time {
 *                         type uint32;
 *                     }
 *                     leaf max-proc-time {
 *                         type uint32;
 *                     }
 *                     leaf average-proc-time {
 *                         type uint32;
 *                     }
 *                     leaf variance-proc-time {
 *                         type uint32;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses overload-object;
 *                 uses pce-id-object;
 *                 uses proc-time-object;
 *             }
 *             container rp {
 *                 container tlvs {
 *                     container order {
 *                         leaf delete {
 *                             type uint32;
 *                         }
 *                         leaf setup {
 *                             type uint32;
 *                         }
 *                         uses tlv;
 *                     }
 *                     container path-setup-type {
 *                         leaf pst {
 *                             type pst;
 *                         }
 *                         uses tlv;
 *                     }
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                     uses order-tlv;
 *                     uses path-setup-type-tlv;
 *                 }
 *                 leaf priority {
 *                     type uint8;
 *                 }
 *                 leaf request-id {
 *                     type request-id;
 *                 }
 *                 leaf reoptimization {
 *                     type reoptimization;
 *                 }
 *                 leaf bi-directional {
 *                     type bi-directional;
 *                 }
 *                 leaf loose {
 *                     type loose;
 *                 }
 *                 leaf path-key {
 *                     type path-key;
 *                 }
 *                 leaf fragmentation {
 *                     type fragmentation;
 *                 }
 *                 leaf p2mp {
 *                     type p2mp;
 *                 }
 *                 leaf ero-compression {
 *                     type ero-compression;
 *                 }
 *                 leaf supply-of {
 *                     type supply-of;
 *                 }
 *                 leaf order {
 *                     type order;
 *                 }
 *                 leaf make-before-break {
 *                     type make-before-break;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container pcc-id-req {
 *                 leaf ip-address {
 *                     type ip-address;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container monitoring {
 *                 leaf flags {
 *                     type bits;
 *                 }
 *                 leaf monitoring-id {
 *                     type uint32;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses rp-object;
 *             uses vendor-information-objects;
 *             uses monitoring-metrics;
 *             uses monitoring;
 *         }
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 *     uses pcrep-message;
 * }
 * notification starttls {
 *     container start-tls-message {
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 *     uses start-tls-message;
 * }
 * notification open {
 *     container open-message {
 *         leaf version {
 *             type version;
 *         }
 *         container open {
 *             container tlvs {
 *                 container of-list {
 *                     leaf-list codes {
 *                         type of-id;
 *                     }
 *                     uses tlv;
 *                 }
 *                 list vendor-information-tlv {
 *                     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses of-list-tlv;
 *                 uses vendor-information-tlvs;
 *             }
 *             leaf version {
 *                 type version;
 *             }
 *             leaf keepalive {
 *                 type uint8;
 *             }
 *             leaf dead-timer {
 *                 type uint8;
 *             }
 *             leaf session-id {
 *                 type uint8;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses message-header;
 *         uses open-object;
 *     }
 *     uses open-message;
 * }
 * notification pcmonreq {
 *     container pcreq-message {
 *         list requests {
 *             container path-key-expansion {
 *                 container path-key {
 *                     list path-keys {
 *                         leaf loose {
 *                             type loose;
 *                         }
 *                         leaf pce-id {
 *                             type pce-id;
 *                         }
 *                         leaf path-key {
 *                             type path-key;
 *                         }
 *                         uses path-key-subobject;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses path-key-object;
 *             }
 *             container segment-computation {
 *                 container p2p {
 *                     container reported-route {
 *                         container reoptimization-bandwidth {
 *                             leaf bandwidth {
 *                                 type bandwidth;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                             uses bandwidth;
 *                         }
 *                         container rro {
 *                             list subobject {
 *                                 leaf protection-available {
 *                                     type protection-available;
 *                                 }
 *                                 leaf protection-in-use {
 *                                     type protection-in-use;
 *                                 }
 *                                 choice subobject-type {
 *                                     case ip-prefix-case {
 *                                         container ip-prefix {
 *                                             leaf ip-prefix {
 *                                                 type ip-prefix;
 *                                             }
 *                                             uses ip-prefix-subobject;
 *                                         }
 *                                     }
 *                                     case label-case {
 *                                         container label {
 *                                             leaf global {
 *                                                 type global;
 *                                             }
 *                                             leaf uni-directional {
 *                                                 type boolean;
 *                                             }
 *                                             choice label-type {
 *                                                 case generalized-label-case {
 *                                                     container generalized-label {
 *                                                         leaf generalized-label {
 *                                                             type binary;
 *                                                         }
 *                                                         uses generalized-label;
 *                                                     }
 *                                                 }
 *                                                 case type1-label-case {
 *                                                     container type1-label {
 *                                                         leaf type1-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses type1-label;
 *                                                     }
 *                                                 }
 *                                                 case waveband-switching-label-case {
 *                                                     container waveband-switching-label {
 *                                                         leaf end-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf start-label {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf waveband-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses waveband-switching-label;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses label-subobject;
 *                                         }
 *                                     }
 *                                     case path-key-case {
 *                                         container path-key {
 *                                             leaf pce-id {
 *                                                 type pce-id;
 *                                             }
 *                                             leaf path-key {
 *                                                 type path-key;
 *                                             }
 *                                             uses path-key-subobject;
 *                                         }
 *                                     }
 *                                     case unnumbered-case {
 *                                         container unnumbered {
 *                                             leaf router-id {
 *                                                 type uint32;
 *                                             }
 *                                             leaf interface-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses unnumbered-subobject;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses record-route-subobjects;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses reoptimization-bandwidth-object;
 *                         uses reported-route-object;
 *                     }
 *                     container endpoints-obj {
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         choice address-family {
 *                             case ipv4-case {
 *                                 container ipv4 {
 *                                     leaf source-ipv4-address {
 *                                         type ipv4-address;
 *                                     }
 *                                     leaf destination-ipv4-address {
 *                                         type ipv4-address;
 *                                     }
 *                                 }
 *                             }
 *                             case ipv6-case {
 *                                 container ipv6 {
 *                                     leaf source-ipv6-address {
 *                                         type ipv6-address;
 *                                     }
 *                                     leaf destination-ipv6-address {
 *                                         type ipv6-address;
 *                                     }
 *                                 }
 *                             }
 *                         }
 *                         uses object;
 *                         uses endpoints;
 *                     }
 *                     list vendor-information-object {
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses object;
 *                     }
 *                     container load-balancing {
 *                         leaf max-lsp {
 *                             type uint8;
 *                         }
 *                         leaf min-bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     list metrics {
 *                         container metric {
 *                             leaf metric-type {
 *                                 type uint8;
 *                             }
 *                             leaf bound {
 *                                 type bound;
 *                             }
 *                             leaf computed {
 *                                 type computed;
 *                             }
 *                             leaf value {
 *                                 type float32;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses metric-object;
 *                     }
 *                     container bandwidth {
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses bandwidth;
 *                     }
 *                     container reoptimization-bandwidth {
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses bandwidth;
 *                     }
 *                     container class-type {
 *                         leaf class-type {
 *                             type class-type;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container lspa {
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         leaf local-protection-desired {
 *                             type local-protection-desired;
 *                         }
 *                         leaf label-recording-desired {
 *                             type label-recording-desired;
 *                         }
 *                         leaf se-style-desired {
 *                             type se-style-desired;
 *                         }
 *                         leaf session-name {
 *                             type string;
 *                         }
 *                         leaf hold-priority {
 *                             type hold-priority;
 *                         }
 *                         leaf setup-priority {
 *                             type setup-priority;
 *                         }
 *                         leaf include-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf exclude-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf include-all {
 *                             type attribute-filter;
 *                         }
 *                         uses tunnel-attributes;
 *                         uses object;
 *                     }
 *                     container of {
 *                         leaf code {
 *                             type of-id;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container rro {
 *                         list subobject {
 *                             leaf protection-available {
 *                                 type protection-available;
 *                             }
 *                             leaf protection-in-use {
 *                                 type protection-in-use;
 *                             }
 *                             choice subobject-type {
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf global {
 *                                             type global;
 *                                         }
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses record-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container xro {
 *                         leaf flags {
 *                             type bits;
 *                         }
 *                         list subobject {
 *                             leaf mandatory {
 *                                 type mandatory;
 *                             }
 *                             leaf attribute {
 *                                 type enumeration;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses exclude-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container iro {
 *                         list subobject {
 *                             leaf loose {
 *                                 type boolean;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case exrs-case {
 *                                     container exrs {
 *                                         list exrs {
 *                                             leaf mandatory {
 *                                                 type mandatory;
 *                                             }
 *                                             leaf attribute {
 *                                                 type enumeration;
 *                                             }
 *                                             choice subobject-type {
 *                                                 case as-number-case {
 *                                                     container as-number {
 *                                                         leaf as-number {
 *                                                             type as-number;
 *                                                         }
 *                                                         uses as-number-subobject;
 *                                                     }
 *                                                 }
 *                                                 case ip-prefix-case {
 *                                                     container ip-prefix {
 *                                                         leaf ip-prefix {
 *                                                             type ip-prefix;
 *                                                         }
 *                                                         uses ip-prefix-subobject;
 *                                                     }
 *                                                 }
 *                                                 case label-case {
 *                                                     container label {
 *                                                         leaf uni-directional {
 *                                                             type boolean;
 *                                                         }
 *                                                         choice label-type {
 *                                                             case generalized-label-case {
 *                                                                 container generalized-label {
 *                                                                     leaf generalized-label {
 *                                                                         type binary;
 *                                                                     }
 *                                                                     uses generalized-label;
 *                                                                 }
 *                                                             }
 *                                                             case type1-label-case {
 *                                                                 container type1-label {
 *                                                                     leaf type1-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses type1-label;
 *                                                                 }
 *                                                             }
 *                                                             case waveband-switching-label-case {
 *                                                                 container waveband-switching-label {
 *                                                                     leaf end-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf start-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf waveband-id {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses waveband-switching-label;
 *                                                                 }
 *                                                             }
 *                                                         }
 *                                                         uses label-subobject;
 *                                                     }
 *                                                 }
 *                                                 case srlg-case {
 *                                                     container srlg {
 *                                                         leaf srlg-id {
 *                                                             type srlg-id;
 *                                                         }
 *                                                         uses srlg-subobject;
 *                                                     }
 *                                                 }
 *                                                 case unnumbered-case {
 *                                                     container unnumbered {
 *                                                         leaf router-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf interface-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses unnumbered-subobject;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses exclude-route-subobjects;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses explicit-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     uses endpoints-object;
 *                     uses vendor-information-objects;
 *                     uses load-balancing-object;
 *                     uses lsp-attributes;
 *                 }
 *             }
 *             list vendor-information-object {
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses object;
 *             }
 *             container rp {
 *                 container tlvs {
 *                     container order {
 *                         leaf delete {
 *                             type uint32;
 *                         }
 *                         leaf setup {
 *                             type uint32;
 *                         }
 *                         uses tlv;
 *                     }
 *                     container path-setup-type {
 *                         leaf pst {
 *                             type pst;
 *                         }
 *                         uses tlv;
 *                     }
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                     uses order-tlv;
 *                     uses path-setup-type-tlv;
 *                 }
 *                 leaf priority {
 *                     type uint8;
 *                 }
 *                 leaf request-id {
 *                     type request-id;
 *                 }
 *                 leaf reoptimization {
 *                     type reoptimization;
 *                 }
 *                 leaf bi-directional {
 *                     type bi-directional;
 *                 }
 *                 leaf loose {
 *                     type loose;
 *                 }
 *                 leaf path-key {
 *                     type path-key;
 *                 }
 *                 leaf fragmentation {
 *                     type fragmentation;
 *                 }
 *                 leaf p2mp {
 *                     type p2mp;
 *                 }
 *                 leaf ero-compression {
 *                     type ero-compression;
 *                 }
 *                 leaf supply-of {
 *                     type supply-of;
 *                 }
 *                 leaf order {
 *                     type order;
 *                 }
 *                 leaf make-before-break {
 *                     type make-before-break;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses rp-object;
 *             uses vendor-information-objects;
 *         }
 *         list svec {
 *             list metric {
 *                 container metric {
 *                     leaf metric-type {
 *                         type uint8;
 *                     }
 *                     leaf bound {
 *                         type bound;
 *                     }
 *                     leaf computed {
 *                         type computed;
 *                     }
 *                     leaf value {
 *                         type float32;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses metric-object;
 *             }
 *             container svec {
 *                 leaf link-diverse {
 *                     type link-diverse;
 *                 }
 *                 leaf node-diverse {
 *                     type node-diverse;
 *                 }
 *                 leaf srlg-diverse {
 *                     type srlg-diverse;
 *                 }
 *                 leaf-list requests-ids {
 *                     type request-id;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             list vendor-information-object {
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses object;
 *             }
 *             container gc {
 *                 leaf max-hop {
 *                     type uint8;
 *                 }
 *                 leaf max-utilization {
 *                     type max-utilization;
 *                 }
 *                 leaf min-utilization {
 *                     type min-utilization;
 *                 }
 *                 leaf over-booking-factor {
 *                     type over-booking-factor;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container of {
 *                 leaf code {
 *                     type of-id;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container xro {
 *                 leaf flags {
 *                     type bits;
 *                 }
 *                 list subobject {
 *                     leaf mandatory {
 *                         type mandatory;
 *                     }
 *                     leaf attribute {
 *                         type enumeration;
 *                     }
 *                     choice subobject-type {
 *                         case as-number-case {
 *                             container as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                                 uses as-number-subobject;
 *                             }
 *                         }
 *                         case ip-prefix-case {
 *                             container ip-prefix {
 *                                 leaf ip-prefix {
 *                                     type ip-prefix;
 *                                 }
 *                                 uses ip-prefix-subobject;
 *                             }
 *                         }
 *                         case label-case {
 *                             container label {
 *                                 leaf uni-directional {
 *                                     type boolean;
 *                                 }
 *                                 choice label-type {
 *                                     case generalized-label-case {
 *                                         container generalized-label {
 *                                             leaf generalized-label {
 *                                                 type binary;
 *                                             }
 *                                             uses generalized-label;
 *                                         }
 *                                     }
 *                                     case type1-label-case {
 *                                         container type1-label {
 *                                             leaf type1-label {
 *                                                 type uint32;
 *                                             }
 *                                             uses type1-label;
 *                                         }
 *                                     }
 *                                     case waveband-switching-label-case {
 *                                         container waveband-switching-label {
 *                                             leaf end-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf start-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf waveband-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses waveband-switching-label;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses label-subobject;
 *                             }
 *                         }
 *                         case srlg-case {
 *                             container srlg {
 *                                 leaf srlg-id {
 *                                     type srlg-id;
 *                                 }
 *                                 uses srlg-subobject;
 *                             }
 *                         }
 *                         case unnumbered-case {
 *                             container unnumbered {
 *                                 leaf router-id {
 *                                     type uint32;
 *                                 }
 *                                 leaf interface-id {
 *                                     type uint32;
 *                                 }
 *                                 uses unnumbered-subobject;
 *                             }
 *                         }
 *                     }
 *                     uses exclude-route-subobjects;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses svec-object;
 *             uses exclude-route-object;
 *             uses gc-object;
 *             uses of-object;
 *             uses vendor-information-objects;
 *         }
 *         container monitoring-request {
 *             list pce-id-list {
 *                 container pce-id {
 *                     leaf ip-address {
 *                         type ip-address;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses pce-id-object;
 *             }
 *             container pcc-id-req {
 *                 leaf ip-address {
 *                     type ip-address;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container monitoring {
 *                 leaf flags {
 *                     type bits;
 *                 }
 *                 leaf monitoring-id {
 *                     type uint32;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses monitoring;
 *         }
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 *     uses pcreq-message;
 * }
 * notification pcmonrep {
 *     container pcmonrep-message {
 *         choice monitoring-metrics-list {
 *             case general-metrics-list {
 *                 list metric-pce {
 *                     container pce-id {
 *                         leaf ip-address {
 *                             type ip-address;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container overload {
 *                         leaf duration {
 *                             type uint16;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container proc-time {
 *                         leaf estimated {
 *                             type boolean;
 *                         }
 *                         leaf current-proc-time {
 *                             type uint32;
 *                         }
 *                         leaf min-proc-time {
 *                             type uint32;
 *                         }
 *                         leaf max-proc-time {
 *                             type uint32;
 *                         }
 *                         leaf average-proc-time {
 *                             type uint32;
 *                         }
 *                         leaf variance-proc-time {
 *                             type uint32;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     uses overload-object;
 *                     uses pce-id-object;
 *                     uses proc-time-object;
 *                 }
 *             }
 *             case specific-metrics-list {
 *                 list specific-metrics {
 *                     list metric-pce {
 *                         container pce-id {
 *                             leaf ip-address {
 *                                 type ip-address;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         container overload {
 *                             leaf duration {
 *                                 type uint16;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         container proc-time {
 *                             leaf estimated {
 *                                 type boolean;
 *                             }
 *                             leaf current-proc-time {
 *                                 type uint32;
 *                             }
 *                             leaf min-proc-time {
 *                                 type uint32;
 *                             }
 *                             leaf max-proc-time {
 *                                 type uint32;
 *                             }
 *                             leaf average-proc-time {
 *                                 type uint32;
 *                             }
 *                             leaf variance-proc-time {
 *                                 type uint32;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses overload-object;
 *                         uses pce-id-object;
 *                         uses proc-time-object;
 *                     }
 *                     container rp {
 *                         container tlvs {
 *                             container order {
 *                                 leaf delete {
 *                                     type uint32;
 *                                 }
 *                                 leaf setup {
 *                                     type uint32;
 *                                 }
 *                                 uses tlv;
 *                             }
 *                             container path-setup-type {
 *                                 leaf pst {
 *                                     type pst;
 *                                 }
 *                                 uses tlv;
 *                             }
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                             uses order-tlv;
 *                             uses path-setup-type-tlv;
 *                         }
 *                         leaf priority {
 *                             type uint8;
 *                         }
 *                         leaf request-id {
 *                             type request-id;
 *                         }
 *                         leaf reoptimization {
 *                             type reoptimization;
 *                         }
 *                         leaf bi-directional {
 *                             type bi-directional;
 *                         }
 *                         leaf loose {
 *                             type loose;
 *                         }
 *                         leaf path-key {
 *                             type path-key;
 *                         }
 *                         leaf fragmentation {
 *                             type fragmentation;
 *                         }
 *                         leaf p2mp {
 *                             type p2mp;
 *                         }
 *                         leaf ero-compression {
 *                             type ero-compression;
 *                         }
 *                         leaf supply-of {
 *                             type supply-of;
 *                         }
 *                         leaf order {
 *                             type order;
 *                         }
 *                         leaf make-before-break {
 *                             type make-before-break;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     uses rp-object;
 *                     uses monitoring-metrics;
 *                 }
 *             }
 *         }
 *         container pcc-id-req {
 *             leaf ip-address {
 *                 type ip-address;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         container monitoring {
 *             leaf flags {
 *                 type bits;
 *             }
 *             leaf monitoring-id {
 *                 type uint32;
 *             }
 *             container tlvs {
 *                 list vendor-information-tlv {
 *                     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses monitoring-response;
 *     }
 *     uses pcmonrep-message;
 * }
 * </pre>
 *
 */
public interface PcepMessageListener
    extends
    NotificationListener
{




    void onPcerr(Pcerr notification);
    
    void onKeepalive(Keepalive notification);
    
    void onClose(Close notification);
    
    void onPcntf(Pcntf notification);
    
    void onPcreq(Pcreq notification);
    
    void onPcrep(Pcrep notification);
    
    void onStarttls(Starttls notification);
    
    void onOpen(Open notification);
    
    void onPcmonreq(Pcmonreq notification);
    
    void onPcmonrep(Pcmonrep notification);

}

