package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcntfMessage;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-message</b>
 * <pre>
 * notification pcntf {
 *     container pcntf-message {
 *         list notifications {
 *             list rps {
 *                 container rp {
 *                     container tlvs {
 *                         container order {
 *                             leaf delete {
 *                                 type uint32;
 *                             }
 *                             leaf setup {
 *                                 type uint32;
 *                             }
 *                             uses tlv;
 *                         }
 *                         container path-setup-type {
 *                             leaf pst {
 *                                 type pst;
 *                             }
 *                             uses tlv;
 *                         }
 *                         list vendor-information-tlv {
 *                             leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         uses vendor-information-tlvs;
 *                         uses order-tlv;
 *                         uses path-setup-type-tlv;
 *                     }
 *                     leaf priority {
 *                         type uint8;
 *                     }
 *                     leaf request-id {
 *                         type request-id;
 *                     }
 *                     leaf reoptimization {
 *                         type reoptimization;
 *                     }
 *                     leaf bi-directional {
 *                         type bi-directional;
 *                     }
 *                     leaf loose {
 *                         type loose;
 *                     }
 *                     leaf path-key {
 *                         type path-key;
 *                     }
 *                     leaf fragmentation {
 *                         type fragmentation;
 *                     }
 *                     leaf p2mp {
 *                         type p2mp;
 *                     }
 *                     leaf ero-compression {
 *                         type ero-compression;
 *                     }
 *                     leaf supply-of {
 *                         type supply-of;
 *                     }
 *                     leaf order {
 *                         type order;
 *                     }
 *                     leaf make-before-break {
 *                         type make-before-break;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses rp-object;
 *             }
 *             list notifications {
 *                 container c-notification {
 *                     container tlvs {
 *                         container overload-duration {
 *                             leaf duration {
 *                                 type duration;
 *                             }
 *                             uses tlv;
 *                         }
 *                         list vendor-information-tlv {
 *                             leaf enterprise-number {
 *                                 type enterprise-number;
 *                             }
 *                             choice enterprise-specific-information {
 *                             }
 *                             uses vendor-information;
 *                             uses tlv;
 *                         }
 *                         uses vendor-information-tlvs;
 *                         uses overload-duration-tlv;
 *                     }
 *                     leaf type {
 *                         type uint8;
 *                     }
 *                     leaf value {
 *                         type uint8;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses notification-object;
 *             }
 *         }
 *         leaf version {
 *             type version;
 *         }
 *         uses message-header;
 *     }
 *     uses pcntf-message;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-message/pcntf</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcntfBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcntfBuilder
 *
 */
public interface Pcntf
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.Pcntf>,
    PcntfMessage,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:message",
        "2013-10-07", "pcntf").intern();


}

