package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth;

/**
 * BANDWIDTH Object
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping bandwidth-object {
 *     container bandwidth {
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         leaf bandwidth {
 *             type bandwidth;
 *         }
 *         uses object;
 *         uses bandwidth;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/bandwidth-object</i>
 *
 */
public interface BandwidthObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "bandwidth-object").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.bandwidth.object.Bandwidth</code> <code>bandwidth</code>, or <code>null</code> if not present
     */
    Bandwidth getBandwidth();

}

