package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.AddressFamily;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping endpoints {
 *     choice address-family {
 *         case ipv4-case {
 *             container ipv4 {
 *                 leaf source-ipv4-address {
 *                     type ipv4-address;
 *                 }
 *                 leaf destination-ipv4-address {
 *                     type ipv4-address;
 *                 }
 *             }
 *         }
 *         case ipv6-case {
 *             container ipv6 {
 *                 leaf source-ipv6-address {
 *                     type ipv6-address;
 *                 }
 *                 leaf destination-ipv6-address {
 *                     type ipv6-address;
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/endpoints</i>
 *
 */
public interface Endpoints
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "endpoints").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.AddressFamily</code> <code>addressFamily</code>, or <code>null</code> if not present
     */
    AddressFamily getAddressFamily();

}

