package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;

/**
 * LSPA Object
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping lspa-object {
 *     container lspa {
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         leaf local-protection-desired {
 *             type local-protection-desired;
 *         }
 *         leaf label-recording-desired {
 *             type label-recording-desired;
 *         }
 *         leaf se-style-desired {
 *             type se-style-desired;
 *         }
 *         leaf session-name {
 *             type string;
 *         }
 *         leaf hold-priority {
 *             type hold-priority;
 *         }
 *         leaf setup-priority {
 *             type setup-priority;
 *         }
 *         leaf include-any {
 *             type attribute-filter;
 *         }
 *         leaf exclude-any {
 *             type attribute-filter;
 *         }
 *         leaf include-all {
 *             type attribute-filter;
 *         }
 *         container tlvs {
 *             list vendor-information-tlv {
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *         }
 *         uses tunnel-attributes;
 *         uses object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/lspa-object</i>
 *
 */
public interface LspaObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "lspa-object").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa</code> <code>lspa</code>, or <code>null</code> if not present
     */
    Lspa getLspa();

}

