package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * NO-PATH Object
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping no-path-object {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     leaf nature-of-issue {
 *         type uint8;
 *     }
 *     leaf unsatisfied-constraints {
 *         type unsatisfied-constraints;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/no-path-object</i>
 *
 */
public interface NoPathObject
    extends
    DataObject,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "no-path-object").intern();

    /**
     * @return <code>java.lang.Short</code> <code>natureOfIssue</code>, or <code>null</code> if not present
     */
    java.lang.Short getNatureOfIssue();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>unsatisfiedConstraints</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isUnsatisfiedConstraints();

}

