package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common Object Header
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping object-header {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/object-header</i>
 *
 */
public interface ObjectHeader
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "object-header").intern();

    /**
     * @return <code>java.lang.Boolean</code> <code>processingRule</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isProcessingRule();
    
    /**
     * @return <code>java.lang.Boolean</code> <code>ignore</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isIgnore();

}

