package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.list.tlv.OfList;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * OF-List TLV
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping of-list-tlv {
 *     container of-list {
 *         leaf-list codes {
 *             type of-id;
 *         }
 *         uses tlv;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/of-list-tlv</i>
 *
 */
public interface OfListTlv
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "of-list-tlv").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.list.tlv.OfList</code> <code>ofList</code>, or <code>null</code> if not present
     */
    OfList getOfList();

}

