package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv.Order;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Order TLV
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping order-tlv {
 *     container order {
 *         leaf delete {
 *             type uint32;
 *         }
 *         leaf setup {
 *             type uint32;
 *         }
 *         uses tlv;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/order-tlv</i>
 *
 */
public interface OrderTlv
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "order-tlv").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv.Order</code> <code>order</code>, or <code>null</code> if not present
     */
    Order getOrder();

}

